/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.docker.compose;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.Transport;

class OpenTelemetryLoggingDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OpenTelemetryLoggingConnectionDetails> {
    private static final String[] OPENTELEMETRY_IMAGE_NAMES = new String[]{"otel/opentelemetry-collector-contrib", "grafana/otel-lgtm"};
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryLoggingDockerComposeConnectionDetailsFactory() {
        super(OPENTELEMETRY_IMAGE_NAMES, new String[]{"org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingExportAutoConfiguration"});
    }

    protected OpenTelemetryLoggingConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryLoggingDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryLoggingDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OpenTelemetryLoggingConnectionDetails {
        private final String host;
        private final int grpcPort;
        private final int httpPort;

        private OpenTelemetryLoggingDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.grpcPort = source.ports().get(4317);
            this.httpPort = source.ports().get(4318);
        }

        @Override
        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> this.httpPort;
                case Transport.GRPC -> this.grpcPort;
            };
            return "http://%s:%d/v1/logs".formatted(this.host, port);
        }
    }
}

