/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.autoconfigure.logging;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import java.util.Locale;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingExportProperties;
import org.springframework.boot.opentelemetry.autoconfigure.logging.Transport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OtlpHttpLogRecordExporter.class})
@ConditionalOnMissingBean(value={OtlpGrpcLogRecordExporter.class, OtlpHttpLogRecordExporter.class})
@ConditionalOnBean(value={OpenTelemetryLoggingConnectionDetails.class})
class OpenTelemetryLoggingTransportConfiguration {
    OpenTelemetryLoggingTransportConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(name={"management.opentelemetry.logging.export.transport"}, havingValue="http", matchIfMissing=true)
    OtlpHttpLogRecordExporter otlpHttpLogRecordExporter(OpenTelemetryLoggingExportProperties properties, OpenTelemetryLoggingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
        OtlpHttpLogRecordExporterBuilder builder = OtlpHttpLogRecordExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.HTTP)).setTimeout(properties.getTimeout()).setConnectTimeout(properties.getConnectTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.US));
        properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
        meterProvider.ifAvailable(arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setMeterProvider(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(name={"management.opentelemetry.logging.export.transport"}, havingValue="grpc")
    OtlpGrpcLogRecordExporter otlpGrpcLogRecordExporter(OpenTelemetryLoggingExportProperties properties, OpenTelemetryLoggingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
        OtlpGrpcLogRecordExporterBuilder builder = OtlpGrpcLogRecordExporter.builder().setEndpoint(connectionDetails.getUrl(Transport.GRPC)).setTimeout(properties.getTimeout()).setConnectTimeout(properties.getConnectTimeout()).setCompression(properties.getCompression().name().toLowerCase(Locale.US));
        properties.getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
        meterProvider.ifAvailable(arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setMeterProvider(arg_0));
        return builder.build();
    }
}

