/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.netty.autoconfigure;

import io.netty.util.NettyRuntime;
import io.netty.util.ResourceLeakDetector;
import org.springframework.boot.LazyInitializationExcludeFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.netty.autoconfigure.NettyProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={NettyRuntime.class})
@EnableConfigurationProperties(value={NettyProperties.class})
public final class NettyAutoConfiguration {
    NettyAutoConfiguration(NettyProperties properties) {
        if (properties.getLeakDetection() != null) {
            NettyProperties.LeakDetection leakDetection = properties.getLeakDetection();
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.valueOf((String)leakDetection.name()));
        }
    }

    @Bean
    static LazyInitializationExcludeFilter nettyAutoConfigurationLazyInitializationExcludeFilter() {
        return LazyInitializationExcludeFilter.forBeanTypes((Class[])new Class[]{NettyAutoConfiguration.class});
    }
}

