/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mustache.servlet.view;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class MustacheView
extends AbstractTemplateView {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Mustache.Compiler compiler;
    private @Nullable String charset;

    public void setCompiler(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCharset(@Nullable String charset) {
        this.charset = charset;
    }

    public boolean checkResource(Locale locale) throws Exception {
        Resource resource = this.getResource();
        return resource != null;
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Resource resource = this.getResource();
        Assert.state((resource != null ? 1 : 0) != 0, (String)"'resource' must not be null");
        Template template = this.createTemplate(resource);
        if (template != null) {
            template.execute(model, (Writer)response.getWriter());
        }
    }

    private @Nullable Resource getResource() {
        ApplicationContext applicationContext = this.getApplicationContext();
        String url = this.getUrl();
        if (applicationContext == null || url == null) {
            return null;
        }
        Resource resource = applicationContext.getResource(url);
        return resource.exists() ? resource : null;
    }

    private Template createTemplate(Resource resource) throws IOException {
        try (Reader reader = this.getReader(resource);){
            Assert.state((this.compiler != null ? 1 : 0) != 0, (String)"'compiler' must not be null");
            Template template = this.compiler.compile(reader);
            return template;
        }
    }

    private Reader getReader(Resource resource) throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(resource.getInputStream(), this.charset);
        }
        return new InputStreamReader(resource.getInputStream());
    }
}

