/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="management.opentelemetry.tracing")
public class OpenTelemetryTracingProperties {
    private final Export export = new Export();

    public Export getExport() {
        return this.export;
    }

    public static class Export {
        private boolean includeUnsampled;
        private Duration timeout = Duration.ofSeconds(30L);
        private int maxBatchSize = 512;
        private int maxQueueSize = 2048;
        private Duration scheduleDelay = Duration.ofSeconds(5L);

        public boolean isIncludeUnsampled() {
            return this.includeUnsampled;
        }

        public void setIncludeUnsampled(boolean includeUnsampled) {
            this.includeUnsampled = includeUnsampled;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public void setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public Duration getScheduleDelay() {
            return this.scheduleDelay;
        }

        public void setScheduleDelay(Duration scheduleDelay) {
            this.scheduleDelay = scheduleDelay;
        }
    }
}

