/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.opentelemetry.testcontainers.otlp;

import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.otlp.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OpenTelemetryTracingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, OtlpTracingConnectionDetails> {
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryTracingContainerConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", new String[]{"org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.otlp.OtlpTracingAutoConfiguration"});
    }

    protected OtlpTracingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OpenTelemetryTracingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryTracingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements OtlpTracingConnectionDetails {
        private OpenTelemetryTracingContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> 4318;
                case Transport.GRPC -> 4317;
            };
            return "http://%s:%d/v1/traces".formatted(this.getContainer().getHost(), this.getContainer().getMappedPort(port));
        }
    }
}

