/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.brave.autoconfigure.zipkin;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.micrometer.tracing.autoconfigure.ConditionalOnEnabledTracingExport;
import org.springframework.context.annotation.Bean;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import zipkin2.reporter.brave.MutableSpanBytesEncoder;

@AutoConfiguration(afterName={"org.springframework.boot.zipkin.autoconfigure.ZipkinAutoConfiguration"})
@ConditionalOnClass(value={Encoding.class, AsyncZipkinSpanHandler.class})
public final class ZipkinWithBraveTracingAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Encoding.class})
    @ConditionalOnMissingBean(value={MutableSpan.class}, parameterizedContainer={BytesEncoder.class})
    BytesEncoder<MutableSpan> mutableSpanBytesEncoder(Encoding encoding, ObjectProvider<Tag<Throwable>> throwableTagProvider) {
        Tag throwableTag = (Tag)throwableTagProvider.getIfAvailable(() -> Tags.ERROR);
        return MutableSpanBytesEncoder.create((Encoding)encoding, (Tag)throwableTag);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={BytesMessageSender.class})
    @ConditionalOnEnabledTracingExport(value="zipkin")
    AsyncZipkinSpanHandler asyncZipkinSpanHandler(BytesMessageSender sender, BytesEncoder<MutableSpan> mutableSpanBytesEncoder) {
        return AsyncZipkinSpanHandler.newBuilder((BytesMessageSender)sender).build(mutableSpanBytesEncoder);
    }
}

