/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp;

import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.CompressionMode;
import io.micrometer.registry.otlp.HistogramFlavor;
import io.micrometer.registry.otlp.OtlpConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp.OtlpMetricsProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.properties.PropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.properties.StepRegistryPropertiesConfigAdapter;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryProperties;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryResourceAttributes;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

class OtlpMetricsPropertiesConfigAdapter
extends StepRegistryPropertiesConfigAdapter<OtlpMetricsProperties>
implements OtlpConfig {
    private final OpenTelemetryProperties openTelemetryProperties;
    private final OtlpMetricsConnectionDetails connectionDetails;
    private final Environment environment;

    OtlpMetricsPropertiesConfigAdapter(OtlpMetricsProperties properties, OpenTelemetryProperties openTelemetryProperties, OtlpMetricsConnectionDetails connectionDetails, Environment environment) {
        super(properties);
        this.connectionDetails = connectionDetails;
        this.openTelemetryProperties = openTelemetryProperties;
        this.environment = environment;
    }

    public String prefix() {
        return "management.otlp.metrics.export";
    }

    public String url() {
        return this.obtain(properties -> this.connectionDetails.getUrl(), () -> super.url());
    }

    public AggregationTemporality aggregationTemporality() {
        return this.obtain(OtlpMetricsProperties::getAggregationTemporality, () -> super.aggregationTemporality());
    }

    public CompressionMode compressionMode() {
        return this.obtain(OtlpMetricsProperties::getCompressionMode, () -> super.compressionMode());
    }

    public Map<String, String> resourceAttributes() {
        LinkedHashMap resourceAttributes = new LinkedHashMap();
        new OpenTelemetryResourceAttributes(this.environment, this.openTelemetryProperties.getResourceAttributes()).applyTo(resourceAttributes::put);
        return Collections.unmodifiableMap(resourceAttributes);
    }

    public Map<String, String> headers() {
        return this.obtain(OtlpMetricsProperties::getHeaders, () -> super.headers());
    }

    public HistogramFlavor histogramFlavor() {
        return this.obtain(OtlpMetricsProperties::getHistogramFlavor, () -> super.histogramFlavor());
    }

    public Map<String, HistogramFlavor> histogramFlavorPerMeter() {
        return this.obtain(this.perMeter(OtlpMetricsProperties.Meter::getHistogramFlavor), () -> super.histogramFlavorPerMeter());
    }

    public Map<String, Integer> maxBucketsPerMeter() {
        return this.obtain(this.perMeter(OtlpMetricsProperties.Meter::getMaxBucketCount), () -> super.maxBucketsPerMeter());
    }

    public boolean publishMaxGaugeForHistograms() {
        return this.obtain(OtlpMetricsProperties::getPublishMaxGaugeForHistograms, () -> super.publishMaxGaugeForHistograms());
    }

    public int maxScale() {
        return this.obtain(OtlpMetricsProperties::getMaxScale, () -> super.maxScale());
    }

    public int maxBucketCount() {
        return this.obtain(OtlpMetricsProperties::getMaxBucketCount, () -> super.maxBucketCount());
    }

    public TimeUnit baseTimeUnit() {
        return this.obtain(OtlpMetricsProperties::getBaseTimeUnit, () -> super.baseTimeUnit());
    }

    private <V> PropertiesConfigAdapter.Getter<OtlpMetricsProperties, Map<String, V>> perMeter(PropertiesConfigAdapter.Getter<OtlpMetricsProperties.Meter, V> getter) {
        return properties -> {
            if (CollectionUtils.isEmpty(properties.getMeter())) {
                return null;
            }
            LinkedHashMap perMeter = new LinkedHashMap();
            properties.getMeter().forEach((key, meterProperties) -> {
                Object value = getter.get((OtlpMetricsProperties.Meter)meterProperties);
                if (value != null) {
                    perMeter.put(key, value);
                }
            });
            return !perMeter.isEmpty() ? perMeter : null;
        };
    }
}

