/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public final class MaximumAllowableTagsMeterFilter
implements MeterFilter {
    private final Log logger;
    private final AtomicBoolean alreadyWarned = new AtomicBoolean();
    private final String meterNamePrefix;
    private final int maximumTagValues;
    private final String tagKey;
    private final Supplier<String> message;
    private final Set<String> observedTagValues = ConcurrentHashMap.newKeySet();

    public MaximumAllowableTagsMeterFilter(String meterNamePrefix, String tagKey, int maximumTagValues) {
        this(meterNamePrefix, tagKey, maximumTagValues, null);
    }

    public MaximumAllowableTagsMeterFilter(String meterNamePrefix, String tagKey, int maximumTagValues, @Nullable String hint) {
        this(null, meterNamePrefix, tagKey, maximumTagValues, () -> String.format("Reached the maximum number of '%s' tags for '%s'.%s", tagKey, meterNamePrefix, hint != null ? " " + hint : ""));
    }

    private MaximumAllowableTagsMeterFilter(@Nullable Log logger, String meterNamePrefix, String tagKey, int maximumTagValues, Supplier<String> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        Assert.isTrue((maximumTagValues >= 0 ? 1 : 0) != 0, (String)"'maximumTagValues' must be positive");
        this.logger = logger != null ? logger : LogFactory.getLog(MaximumAllowableTagsMeterFilter.class);
        this.meterNamePrefix = meterNamePrefix;
        this.maximumTagValues = maximumTagValues;
        this.tagKey = tagKey;
        this.message = message;
    }

    public MeterFilterReply accept(Meter.Id id) {
        String tagValue;
        if (this.meterNamePrefix == null) {
            return this.logAndDeny();
        }
        String string = tagValue = id.getName().startsWith(this.meterNamePrefix) ? id.getTag(this.tagKey) : null;
        if (tagValue != null && !this.observedTagValues.contains(tagValue)) {
            if (this.observedTagValues.size() >= this.maximumTagValues) {
                return this.logAndDeny();
            }
            this.observedTagValues.add(tagValue);
        }
        return MeterFilterReply.NEUTRAL;
    }

    private MeterFilterReply logAndDeny() {
        if (this.logger.isWarnEnabled() && this.alreadyWarned.compareAndSet(false, true)) {
            this.logger.warn((Object)this.message.get());
        }
        return MeterFilterReply.DENY;
    }
}

