/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.boot.buildpack.platform.build.AbstractBuildLog;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Builder;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.ImagePackager;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.maven.AbstractPackagerMojo;
import org.springframework.boot.maven.Docker;
import org.springframework.boot.maven.Image;
import org.springframework.boot.maven.JavaCompilerPluginConfiguration;
import org.springframework.boot.maven.VersionExtractor;
import org.springframework.util.StringUtils;

@Mojo(name="build-image", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class BuildImageMojo
extends AbstractPackagerMojo {
    private static final String BUILDPACK_JVM_VERSION_KEY = "BP_JVM_VERSION";
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(property="spring-boot.build-image.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String classifier;
    @Parameter
    private Image image;
    @Parameter(property="spring-boot.build-image.imageName", readonly=true)
    String imageName;
    @Parameter(property="spring-boot.build-image.builder", readonly=true)
    String imageBuilder;
    @Parameter(property="spring-boot.build-image.runImage", readonly=true)
    String runImage;
    @Parameter(property="spring-boot.build-image.pullPolicy", readonly=true)
    PullPolicy pullPolicy;
    @Parameter(property="spring-boot.build-image.publish", readonly=true)
    Boolean publish;
    @Parameter
    private Docker docker;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"build-image goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping build-image as per configuration.");
            return;
        }
        this.buildImage();
    }

    private void buildImage() throws MojoExecutionException {
        Libraries libraries = this.getLibraries(Collections.emptySet());
        try {
            DockerConfiguration dockerConfiguration = this.docker != null ? this.docker.asDockerConfiguration() : null;
            Builder builder = new Builder((BuildLog)new MojoBuildLog(() -> ((BuildImageMojo)this).getLog()), dockerConfiguration);
            BuildRequest request = this.getBuildRequest(libraries);
            builder.build(request);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private BuildRequest getBuildRequest(Libraries libraries) throws MojoExecutionException {
        Image image;
        Function<Owner, TarArchive> content = owner -> this.getApplicationContent((Owner)owner, libraries);
        Image image2 = image = this.image != null ? this.image : new Image();
        if (image.name == null && this.imageName != null) {
            image.setName(this.imageName);
        }
        if (image.builder == null && this.imageBuilder != null) {
            image.setBuilder(this.imageBuilder);
        }
        if (image.runImage == null && this.runImage != null) {
            image.setRunImage(this.runImage);
        }
        if (image.pullPolicy == null && this.pullPolicy != null) {
            image.setPullPolicy(this.pullPolicy);
        }
        if (image.publish == null && this.publish != null) {
            image.setPublish(this.publish);
        }
        if (image.publish != null && image.publish.booleanValue() && this.publishRegistryNotConfigured()) {
            throw new MojoExecutionException("Publishing an image requires docker.publishRegistry to be configured");
        }
        return this.customize(image.getBuildRequest(this.project.getArtifact(), content));
    }

    private boolean publishRegistryNotConfigured() {
        return this.docker == null || this.docker.getPublishRegistry() == null || this.docker.getPublishRegistry().isEmpty();
    }

    private TarArchive getApplicationContent(Owner owner, Libraries libraries) {
        ImagePackager packager = this.getConfiguredPackager(() -> new ImagePackager(this.getJarFile()));
        return new PackagedTarArchive(owner, libraries, packager);
    }

    private File getJarFile() {
        StringBuilder name = new StringBuilder(this.finalName);
        if (StringUtils.hasText((String)this.classifier)) {
            name.append("-").append(this.classifier);
        }
        name.append(".jar");
        return new File(this.sourceDirectory, name.toString());
    }

    private BuildRequest customize(BuildRequest request) {
        request = this.customizeEnvironment(request);
        request = this.customizeCreator(request);
        return request;
    }

    private BuildRequest customizeEnvironment(BuildRequest request) {
        JavaCompilerPluginConfiguration compilerConfiguration;
        String targetJavaVersion;
        if (!request.getEnv().containsKey(BUILDPACK_JVM_VERSION_KEY) && StringUtils.hasText((String)(targetJavaVersion = (compilerConfiguration = new JavaCompilerPluginConfiguration(this.project)).getTargetMajorVersion()))) {
            return request.withEnv(BUILDPACK_JVM_VERSION_KEY, targetJavaVersion + ".*");
        }
        return request;
    }

    private BuildRequest customizeCreator(BuildRequest request) {
        String springBootVersion = VersionExtractor.forClass(BuildImageMojo.class);
        if (StringUtils.hasText((String)springBootVersion)) {
            request = request.withCreator(Creator.withVersion((String)springBootVersion));
        }
        return request;
    }

    static {
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.http.wire", "ERROR");
    }

    static class PackagedTarArchive
    implements TarArchive {
        static final long NORMALIZED_MOD_TIME = TarArchive.NORMALIZED_TIME.toEpochMilli();
        private final Owner owner;
        private final Libraries libraries;
        private final ImagePackager packager;

        PackagedTarArchive(Owner owner, Libraries libraries, ImagePackager packager) {
            this.owner = owner;
            this.libraries = libraries;
            this.packager = packager;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            TarArchiveOutputStream tar = new TarArchiveOutputStream(outputStream);
            tar.setLongFileMode(3);
            this.packager.packageImage(this.libraries, (entry, entryWriter) -> this.write((ZipEntry)entry, (EntryWriter)entryWriter, tar));
        }

        private void write(ZipEntry jarEntry, EntryWriter entryWriter, TarArchiveOutputStream tar) {
            try {
                TarArchiveEntry tarEntry = this.convert(jarEntry);
                tar.putArchiveEntry((ArchiveEntry)tarEntry);
                if (tarEntry.isFile()) {
                    entryWriter.write((OutputStream)tar);
                }
                tar.closeArchiveEntry();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private TarArchiveEntry convert(ZipEntry entry) {
            byte linkFlag = entry.isDirectory() ? (byte)53 : 48;
            TarArchiveEntry tarEntry = new TarArchiveEntry(entry.getName(), linkFlag, true);
            tarEntry.setUserId(this.owner.getUid());
            tarEntry.setGroupId(this.owner.getGid());
            tarEntry.setModTime(NORMALIZED_MOD_TIME);
            if (!entry.isDirectory()) {
                tarEntry.setSize(entry.getSize());
            }
            return tarEntry;
        }
    }

    private static class MojoBuildLog
    extends AbstractBuildLog {
        private static final long THRESHOLD = Duration.ofSeconds(2L).toMillis();
        private final Supplier<Log> log;

        MojoBuildLog(Supplier<Log> log) {
            this.log = log;
        }

        protected void log(String message) {
            this.log.get().info((CharSequence)message);
        }

        protected Consumer<TotalProgressEvent> getProgressConsumer(String message) {
            return new ProgressLog(message);
        }

        private class ProgressLog
        implements Consumer<TotalProgressEvent> {
            private final String message;
            private long last;

            ProgressLog(String message) {
                this.message = message;
                this.last = System.currentTimeMillis();
            }

            @Override
            public void accept(TotalProgressEvent progress) {
                this.log(progress.getPercent());
            }

            private void log(int percent) {
                if (percent == 100 || System.currentTimeMillis() - this.last > THRESHOLD) {
                    ((Log)MojoBuildLog.this.log.get()).info((CharSequence)(this.message + " " + percent + "%"));
                    this.last = System.currentTimeMillis();
                }
            }
        }
    }
}

