/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.boot.loader.tools.InputStreamSupplier;

final class Digest {
    private Digest() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String sha1(InputStreamSupplier supplier) throws IOException {
        try (DigestInputStream inputStream = new DigestInputStream(supplier.openStream(), MessageDigest.getInstance("SHA-1"));){
            byte[] buffer = new byte[4098];
            while (inputStream.read(buffer) != -1) {
            }
            String string = Digest.bytesToHex(inputStream.getMessageDigest().digest());
            return string;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }
}

