/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jarmode;

import java.util.List;
import org.springframework.boot.loader.jarmode.JarMode;
import org.springframework.boot.loader.jarmode.JarModeErrorException;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;

public final class JarModeLauncher {
    static final String DISABLE_SYSTEM_EXIT = JarModeLauncher.class.getName() + ".DISABLE_SYSTEM_EXIT";
    static final String SUPPRESSED_SYSTEM_EXIT_CODE = JarModeLauncher.class.getName() + ".SUPPRESSED_SYSTEM_EXIT_CODE";

    private JarModeLauncher() {
    }

    public static void main(String[] args) {
        String mode = System.getProperty("jarmode");
        boolean disableSystemExit = Boolean.getBoolean(DISABLE_SYSTEM_EXIT);
        try {
            JarModeLauncher.runJarMode(mode, args);
            if (disableSystemExit) {
                System.setProperty(SUPPRESSED_SYSTEM_EXIT_CODE, "0");
            }
        }
        catch (Throwable ex) {
            JarModeLauncher.printError(ex);
            if (disableSystemExit) {
                System.setProperty(SUPPRESSED_SYSTEM_EXIT_CODE, "1");
                return;
            }
            System.exit(1);
        }
    }

    private static void runJarMode(String mode, String[] args) {
        List candidates = SpringFactoriesLoader.loadFactories(JarMode.class, (ClassLoader)ClassUtils.getDefaultClassLoader());
        for (JarMode candidate : candidates) {
            if (!candidate.accepts(mode)) continue;
            candidate.run(mode, args);
            return;
        }
        throw new JarModeErrorException("Unsupported jarmode '" + mode + "'");
    }

    private static void printError(Throwable ex) {
        if (ex instanceof JarModeErrorException) {
            String message = ex.getMessage();
            System.err.println("Error: " + message);
            System.err.println();
            return;
        }
        ex.printStackTrace();
    }
}

