/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase.autoconfigure;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.jdbc.SchemaManagement;
import org.springframework.boot.jdbc.SchemaManagementProvider;

class LiquibaseSchemaManagementProvider
implements SchemaManagementProvider {
    private final Iterable<SpringLiquibase> liquibaseInstances;

    LiquibaseSchemaManagementProvider(ObjectProvider<SpringLiquibase> liquibases) {
        this.liquibaseInstances = liquibases;
    }

    public SchemaManagement getSchemaManagement(DataSource dataSource) {
        return StreamSupport.stream(this.liquibaseInstances.spliterator(), false).map(SpringLiquibase::getDataSource).filter((Predicate<DataSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljavax/sql/DataSource;)Z)((DataSource)dataSource)).findFirst().map(managedDataSource -> SchemaManagement.MANAGED).orElse(SchemaManagement.UNMANAGED);
    }
}

