/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ldap.docker.compose;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.ldap.autoconfigure.LdapConnectionDetails;

class OpenLdapDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<LdapConnectionDetails> {
    protected OpenLdapDockerComposeConnectionDetailsFactory() {
        super("osixia/openldap", new String[0]);
    }

    protected LdapConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenLdapDockerComposeConnectionDetails(source.getRunningService());
    }

    static class OpenLdapDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements LdapConnectionDetails {
        private final String[] urls;
        private final String base;
        private final String username;
        private final String password;

        OpenLdapDockerComposeConnectionDetails(RunningService service) {
            super(service);
            Map env = service.env();
            boolean usesTls = Boolean.parseBoolean(env.getOrDefault("LDAP_TLS", "true"));
            String ldapPort = usesTls ? env.getOrDefault("LDAPS_PORT", "636") : env.getOrDefault("LDAP_PORT", "389");
            this.urls = new String[]{"%s://%s:%d".formatted(usesTls ? "ldaps" : "ldap", service.host(), service.ports().get(Integer.parseInt(ldapPort)))};
            if (env.containsKey("LDAP_BASE_DN")) {
                this.base = (String)env.get("LDAP_BASE_DN");
            } else {
                String string = "dc=%s";
                this.base = Arrays.stream(env.getOrDefault("LDAP_DOMAIN", "example.org").split("\\.")).map(arg_0 -> OpenLdapDockerComposeConnectionDetails.lambda$new$0("dc=%s", arg_0)).collect(Collectors.joining(","));
            }
            this.password = env.getOrDefault("LDAP_ADMIN_PASSWORD", "admin");
            this.username = "cn=admin,%s".formatted(this.base);
        }

        @Override
        public String[] getUrls() {
            return this.urls;
        }

        @Override
        public String getBase() {
            return this.base;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        private static /* synthetic */ String lambda$new$0(String rec$, Object xva$0) {
            return "dc=%s".formatted(xva$0);
        }
    }
}

