/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.jetty.metrics.JettyConnectionMetricsBinder;
import org.springframework.boot.jetty.metrics.JettyServerThreadPoolMetricsBinder;
import org.springframework.boot.jetty.metrics.JettySslHandshakeMetricsBinder;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnWebApplication
@ConditionalOnClass(value={JettyServerThreadPoolMetrics.class, Server.class, MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public final class JettyMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JettyServerThreadPoolMetrics.class, JettyServerThreadPoolMetricsBinder.class})
    JettyServerThreadPoolMetricsBinder jettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry) {
        return new JettyServerThreadPoolMetricsBinder(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JettyConnectionMetrics.class, JettyConnectionMetricsBinder.class})
    JettyConnectionMetricsBinder jettyConnectionMetricsBinder(MeterRegistry meterRegistry) {
        return new JettyConnectionMetricsBinder(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JettySslHandshakeMetrics.class, JettySslHandshakeMetricsBinder.class})
    @ConditionalOnBooleanProperty(value={"server.ssl.enabled"})
    JettySslHandshakeMetricsBinder jettySslHandshakeMetricsBinder(MeterRegistry meterRegistry) {
        return new JettySslHandshakeMetricsBinder(meterRegistry);
    }
}

