/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jetty.GracefulShutdown;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JettyWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(JettyWebServer.class);
    private final Object monitor = new Object();
    private final Server server;
    private final boolean autoStart;
    private final @Nullable GracefulShutdown gracefulShutdown;
    private Connector[] connectors;
    private volatile boolean started;

    public JettyWebServer(Server server) {
        this(server, true);
    }

    public JettyWebServer(Server server, boolean autoStart) {
        this.autoStart = autoStart;
        Assert.notNull((Object)server, (String)"'server' must not be null");
        this.server = server;
        this.gracefulShutdown = this.createGracefulShutdown(server);
        this.initialize();
    }

    private @Nullable GracefulShutdown createGracefulShutdown(Server server) {
        StatisticsHandler statisticsHandler = this.findStatisticsHandler(server);
        if (statisticsHandler == null) {
            return null;
        }
        return new GracefulShutdown(server, () -> ((StatisticsHandler)statisticsHandler).getRequestsActive());
    }

    private @Nullable StatisticsHandler findStatisticsHandler(Server server) {
        return this.findStatisticsHandler(server.getHandler());
    }

    private @Nullable StatisticsHandler findStatisticsHandler(Handler handler) {
        if (handler instanceof StatisticsHandler) {
            StatisticsHandler statisticsHandler = (StatisticsHandler)handler;
            return statisticsHandler;
        }
        if (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            return this.findStatisticsHandler(handlerWrapper.getHandler());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.connectors = this.server.getConnectors();
                this.server.setConnectors(null);
                this.server.start();
                this.server.setStopAtShutdown(false);
            }
            catch (Throwable ex) {
                this.stopSilently();
                throw new WebServerException("Unable to start embedded Jetty web server", ex);
            }
        }
    }

    private void stopSilently() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.server.setConnectors(this.connectors);
            if (!this.autoStart) {
                return;
            }
            try {
                Connector[] connectors;
                this.server.start();
                this.handleDeferredInitialize(this.server);
                for (Connector connector : connectors = this.server.getConnectors()) {
                    try {
                        connector.start();
                    }
                    catch (IOException ex) {
                        if (connector instanceof NetworkConnector) {
                            NetworkConnector networkConnector = (NetworkConnector)connector;
                            PortInUseException.throwIfPortBindingException((Exception)ex, () -> ((NetworkConnector)networkConnector).getPort());
                        }
                        throw ex;
                    }
                }
                this.started = true;
                logger.info((Object)this.getStartedLogMessage());
            }
            catch (WebServerException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                this.stopSilently();
                throw new WebServerException("Unable to start embedded Jetty server", (Throwable)ex);
            }
        }
    }

    String getStartedLogMessage() {
        String contextPath = this.getContextPath();
        return "Jetty started on " + this.getActualPortsDescription() + (String)(contextPath != null ? " with context path '" + contextPath + "'" : "");
    }

    private String getActualPortsDescription() {
        StringBuilder description = new StringBuilder("port");
        Connector[] connectors = this.server.getConnectors();
        if (connectors.length != 1) {
            description.append("s");
        }
        description.append(" ");
        for (int i = 0; i < connectors.length; ++i) {
            if (i != 0) {
                description.append(", ");
            }
            Connector connector = connectors[i];
            description.append(this.getLocalPort(connector)).append(this.getProtocols(connector));
        }
        return description.toString();
    }

    private String getProtocols(Connector connector) {
        List protocols = connector.getProtocols();
        return " (" + StringUtils.collectionToDelimitedString((Collection)protocols, (String)", ") + ")";
    }

    private @Nullable String getContextPath() {
        List<ContextHandler> imperativeContextHandlers = this.server.getHandlers().stream().map(this::findContextHandler).filter(Objects::nonNull).filter(this::isImperative).toList();
        if (imperativeContextHandlers.isEmpty()) {
            return null;
        }
        return imperativeContextHandlers.stream().map(ContextHandler::getContextPath).collect(Collectors.joining(" "));
    }

    private @Nullable ContextHandler findContextHandler(Handler handler) {
        while (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            if (handler instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)handler;
                return contextHandler;
            }
            handler = handlerWrapper.getHandler();
        }
        return null;
    }

    private boolean isImperative(ContextHandler contextHandler) {
        if (contextHandler instanceof ServletContextHandler) {
            ServletContextHandler servletContextHandler = (ServletContextHandler)contextHandler;
            Collection servletHolders = servletContextHandler.getServletHandler().getBeans(ServletHolder.class);
            for (ServletHolder servletHolder : servletHolders) {
                if (!ServletHttpHandlerAdapter.class.getName().equals(servletHolder.getClassName())) continue;
                return false;
            }
        }
        return true;
    }

    protected void handleDeferredInitialize(Server server) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            this.started = false;
            if (this.gracefulShutdown != null) {
                this.gracefulShutdown.abort();
            }
            try {
                for (Connector connector : this.server.getConnectors()) {
                    connector.stop();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop embedded Jetty server", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to destroy embedded Jetty server", (Throwable)ex);
            }
        }
    }

    public int getPort() {
        Connector[] connectors;
        for (Connector connector : connectors = this.server.getConnectors()) {
            int localPort = this.getLocalPort(connector);
            if (localPort <= 0) continue;
            return localPort;
        }
        return -1;
    }

    private int getLocalPort(Connector connector) {
        if (connector instanceof NetworkConnector) {
            NetworkConnector networkConnector = (NetworkConnector)connector;
            return networkConnector.getLocalPort();
        }
        return 0;
    }

    public void shutDownGracefully(GracefulShutdownCallback callback) {
        if (this.gracefulShutdown == null) {
            callback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        this.gracefulShutdown.shutDownGracefully(callback);
    }

    public Server getServer() {
        return this.server;
    }
}

