/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWarDeployment;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.jetty.autoconfigure.JettyVirtualThreadsWebServerFactoryCustomizer;
import org.springframework.boot.jetty.autoconfigure.JettyWebServerFactoryCustomizer;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@ConditionalOnNotWarDeployment
@Configuration(proxyBeanMethods=false)
public class JettyWebServerConfiguration {
    private final JettyServerProperties jettyProperties;

    public JettyWebServerConfiguration(JettyServerProperties jettyProperties) {
        this.jettyProperties = jettyProperties;
    }

    @Bean
    JettyWebServerFactoryCustomizer jettyWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties) {
        return new JettyWebServerFactoryCustomizer(environment, serverProperties, this.jettyProperties);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    JettyVirtualThreadsWebServerFactoryCustomizer jettyVirtualThreadsWebServerFactoryCustomizer() {
        return new JettyVirtualThreadsWebServerFactoryCustomizer(this.jettyProperties);
    }
}

