/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure;

import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="server.jetty")
public class JettyServerProperties {
    private DataSize maxHttpFormPostSize = DataSize.ofBytes((long)200000L);
    private int maxFormKeys = 1000;
    private @Nullable Duration connectionIdleTimeout;
    private DataSize maxHttpResponseHeaderSize = DataSize.ofKilobytes((long)16L);
    private int maxConnections = -1;
    private final Accesslog accesslog = new Accesslog();
    private final Threads threads = new Threads();

    public Accesslog getAccesslog() {
        return this.accesslog;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public DataSize getMaxHttpFormPostSize() {
        return this.maxHttpFormPostSize;
    }

    public void setMaxHttpFormPostSize(DataSize maxHttpFormPostSize) {
        this.maxHttpFormPostSize = maxHttpFormPostSize;
    }

    public int getMaxFormKeys() {
        return this.maxFormKeys;
    }

    public void setMaxFormKeys(int maxFormKeys) {
        this.maxFormKeys = maxFormKeys;
    }

    public @Nullable Duration getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public void setConnectionIdleTimeout(@Nullable Duration connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public DataSize getMaxHttpResponseHeaderSize() {
        return this.maxHttpResponseHeaderSize;
    }

    public void setMaxHttpResponseHeaderSize(DataSize maxHttpResponseHeaderSize) {
        this.maxHttpResponseHeaderSize = maxHttpResponseHeaderSize;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public static class Accesslog {
        private boolean enabled = false;
        private Format format = Format.NCSA;
        private @Nullable String customFormat;
        private @Nullable String filename;
        private @Nullable String fileDateFormat;
        private int retentionPeriod = 31;
        private boolean append;
        private @Nullable List<String> ignorePaths;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setFormat(Format format) {
            this.format = format;
        }

        public @Nullable String getCustomFormat() {
            return this.customFormat;
        }

        public void setCustomFormat(@Nullable String customFormat) {
            this.customFormat = customFormat;
        }

        public @Nullable String getFilename() {
            return this.filename;
        }

        public void setFilename(@Nullable String filename) {
            this.filename = filename;
        }

        public @Nullable String getFileDateFormat() {
            return this.fileDateFormat;
        }

        public void setFileDateFormat(@Nullable String fileDateFormat) {
            this.fileDateFormat = fileDateFormat;
        }

        public int getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public void setRetentionPeriod(int retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public boolean isAppend() {
            return this.append;
        }

        public void setAppend(boolean append) {
            this.append = append;
        }

        public @Nullable List<String> getIgnorePaths() {
            return this.ignorePaths;
        }

        public void setIgnorePaths(@Nullable List<String> ignorePaths) {
            this.ignorePaths = ignorePaths;
        }

        public static enum Format {
            NCSA,
            EXTENDED_NCSA;

        }
    }

    public static class Threads {
        private Integer acceptors = -1;
        private Integer selectors = -1;
        private Integer max = 200;
        private Integer min = 8;
        private @Nullable Integer maxQueueCapacity;
        private Duration idleTimeout = Duration.ofMillis(60000L);

        public Integer getAcceptors() {
            return this.acceptors;
        }

        public void setAcceptors(Integer acceptors) {
            this.acceptors = acceptors;
        }

        public Integer getSelectors() {
            return this.selectors;
        }

        public void setSelectors(Integer selectors) {
            this.selectors = selectors;
        }

        public void setMin(Integer min) {
            this.min = min;
        }

        public Integer getMin() {
            return this.min;
        }

        public void setMax(Integer max) {
            this.max = max;
        }

        public Integer getMax() {
            return this.max;
        }

        public @Nullable Integer getMaxQueueCapacity() {
            return this.maxQueueCapacity;
        }

        public void setMaxQueueCapacity(@Nullable Integer maxQueueCapacity) {
            this.maxQueueCapacity = maxQueueCapacity;
        }

        public void setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
        }

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }
    }
}

