/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.docker.compose;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.docker.compose.JdbcUrlBuilder;
import org.springframework.boot.jdbc.docker.compose.MariaDbEnvironment;

class MariaDbJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    protected MariaDbJdbcDockerComposeConnectionDetailsFactory() {
        super("mariadb", new String[0]);
    }

    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MariaDbJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MariaDbJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new JdbcUrlBuilder("mariadb", 3306);
        private final MariaDbEnvironment environment;
        private final String jdbcUrl;

        MariaDbJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new MariaDbEnvironment(service.env());
            this.jdbcUrl = jdbcUrlBuilder.build(service, this.environment.getDatabase());
        }

        @Override
        public String getUsername() {
            return this.environment.getUsername();
        }

        @Override
        public String getPassword() {
            return this.environment.getPassword();
        }

        @Override
        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

