/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.datasource")
public class DataSourceProperties
implements BeanClassLoaderAware,
InitializingBean {
    private ClassLoader classLoader;
    private boolean generateUniqueName = true;
    private @Nullable String name;
    private @Nullable Class<? extends DataSource> type;
    private @Nullable String driverClassName;
    private @Nullable String url;
    private @Nullable String username;
    private @Nullable String password;
    private @Nullable String jndiName;
    private EmbeddedDatabaseConnection embeddedDatabaseConnection;
    private Xa xa = new Xa();
    private @Nullable String uniqueName;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.embeddedDatabaseConnection == null) {
            this.embeddedDatabaseConnection = EmbeddedDatabaseConnection.get(this.classLoader);
        }
    }

    public DataSourceBuilder<?> initializeDataSourceBuilder() {
        return DataSourceBuilder.create(this.getClassLoader()).type(this.getType()).driverClassName(this.determineDriverClassName()).url(this.determineUrl()).username(this.determineUsername()).password(this.determinePassword());
    }

    public boolean isGenerateUniqueName() {
        return this.generateUniqueName;
    }

    public void setGenerateUniqueName(boolean generateUniqueName) {
        this.generateUniqueName = generateUniqueName;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable Class<? extends DataSource> getType() {
        return this.type;
    }

    public void setType(@Nullable Class<? extends DataSource> type) {
        this.type = type;
    }

    public @Nullable String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(@Nullable String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String determineDriverClassName() {
        String driverClassName = this.findDriverClassName();
        if (!StringUtils.hasText((String)driverClassName)) {
            throw new DataSourceBeanCreationException("Failed to determine a suitable driver class", this, this.embeddedDatabaseConnection);
        }
        return driverClassName;
    }

    @Nullable String findDriverClassName() {
        if (StringUtils.hasText((String)this.driverClassName)) {
            Assert.state((boolean)this.driverClassIsLoadable(this.driverClassName), () -> "Cannot load driver class: " + this.driverClassName);
            return this.driverClassName;
        }
        String driverClassName = null;
        if (StringUtils.hasText((String)this.url)) {
            driverClassName = DatabaseDriver.fromJdbcUrl(this.url).getDriverClassName();
        }
        if (!StringUtils.hasText(driverClassName)) {
            driverClassName = this.embeddedDatabaseConnection.getDriverClassName();
        }
        return driverClassName;
    }

    private boolean driverClassIsLoadable(String driverClassName) {
        try {
            ClassUtils.forName((String)driverClassName, null);
            return true;
        }
        catch (UnsupportedClassVersionError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public String determineUrl() {
        String url;
        if (StringUtils.hasText((String)this.url)) {
            return this.url;
        }
        String databaseName = this.determineDatabaseName();
        String string = url = databaseName != null ? this.embeddedDatabaseConnection.getUrl(databaseName) : null;
        if (!StringUtils.hasText((String)url)) {
            throw new DataSourceBeanCreationException("Failed to determine suitable jdbc url", this, this.embeddedDatabaseConnection);
        }
        return url;
    }

    public @Nullable String determineDatabaseName() {
        if (this.generateUniqueName) {
            if (this.uniqueName == null) {
                this.uniqueName = UUID.randomUUID().toString();
            }
            return this.uniqueName;
        }
        if (StringUtils.hasLength((String)this.name)) {
            return this.name;
        }
        if (this.embeddedDatabaseConnection != EmbeddedDatabaseConnection.NONE) {
            return "testdb";
        }
        return null;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public @Nullable String determineUsername() {
        if (StringUtils.hasText((String)this.username)) {
            return this.username;
        }
        if (EmbeddedDatabaseConnection.isEmbedded(this.findDriverClassName(), this.determineUrl())) {
            return "sa";
        }
        return null;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public @Nullable String determinePassword() {
        if (StringUtils.hasText((String)this.password)) {
            return this.password;
        }
        if (EmbeddedDatabaseConnection.isEmbedded(this.findDriverClassName(), this.determineUrl())) {
            return "";
        }
        return null;
    }

    public @Nullable String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(@Nullable String jndiName) {
        this.jndiName = jndiName;
    }

    public EmbeddedDatabaseConnection getEmbeddedDatabaseConnection() {
        return this.embeddedDatabaseConnection;
    }

    public void setEmbeddedDatabaseConnection(EmbeddedDatabaseConnection embeddedDatabaseConnection) {
        this.embeddedDatabaseConnection = embeddedDatabaseConnection;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Xa getXa() {
        return this.xa;
    }

    public void setXa(Xa xa) {
        this.xa = xa;
    }

    public static class Xa {
        private @Nullable String dataSourceClassName;
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        public @Nullable String getDataSourceClassName() {
            return this.dataSourceClassName;
        }

        public void setDataSourceClassName(@Nullable String dataSourceClassName) {
            this.dataSourceClassName = dataSourceClassName;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    static class DataSourceBeanCreationException
    extends BeanCreationException {
        private final DataSourceProperties properties;
        private final EmbeddedDatabaseConnection connection;

        DataSourceBeanCreationException(String message, DataSourceProperties properties, EmbeddedDatabaseConnection connection) {
            super(message);
            this.properties = properties;
            this.connection = connection;
        }

        DataSourceProperties getProperties() {
            return this.properties;
        }

        EmbeddedDatabaseConnection getConnection() {
            return this.connection;
        }
    }
}

