/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jarmode.tools.MissingValueException;
import org.springframework.boot.jarmode.tools.UnknownOptionException;

abstract class Command {
    private final String name;
    private final String description;
    private final Options options;
    private final Parameters parameters;

    Command(String name, String description, Options options, Parameters parameters) {
        this.name = name;
        this.description = description;
        this.options = options;
        this.parameters = parameters;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    Options getOptions() {
        return this.options;
    }

    Parameters getParameters() {
        return this.parameters;
    }

    final void run(PrintStream out, Deque<String> args) {
        ArrayList<String> parameters = new ArrayList<String>();
        HashMap<Option, String> options = new HashMap<Option, String>();
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            Option option = this.options.find(arg);
            if (option != null) {
                options.put(option, option.claimArg(args));
                continue;
            }
            parameters.add(arg);
        }
        this.run(out, options, parameters);
    }

    abstract void run(PrintStream var1, Map<Option, String> var2, List<String> var3);

    boolean isDeprecated() {
        return false;
    }

    @Nullable String getDeprecationMessage() {
        return null;
    }

    static @Nullable Command find(Collection<? extends Command> commands, String name) {
        for (Command command : commands) {
            if (!command.getName().equals(name)) continue;
            return command;
        }
        return null;
    }

    static final class Options {
        private final Option[] values;

        private Options(Option[] values) {
            this.values = values;
        }

        private @Nullable Option find(String arg) {
            if (arg.startsWith("--")) {
                String name = arg.substring(2);
                for (Option candidate : this.values) {
                    if (!candidate.getName().equals(name)) continue;
                    return candidate;
                }
                throw new UnknownOptionException(name);
            }
            return null;
        }

        boolean isEmpty() {
            return this.values.length == 0;
        }

        Stream<Option> stream() {
            return Arrays.stream(this.values);
        }

        static Options none() {
            return Options.of(new Option[0]);
        }

        static Options of(Option ... values) {
            return new Options(values);
        }
    }

    static final class Parameters {
        private final List<String> descriptions;

        private Parameters(String[] descriptions) {
            this.descriptions = Collections.unmodifiableList(Arrays.asList(descriptions));
        }

        List<String> getDescriptions() {
            return this.descriptions;
        }

        public String toString() {
            return this.descriptions.toString();
        }

        static Parameters none() {
            return Parameters.of(new String[0]);
        }

        static Parameters of(String ... descriptions) {
            return new Parameters(descriptions);
        }
    }

    static final class Option {
        private final String name;
        private final @Nullable String valueDescription;
        private final String description;
        private final boolean optionalValue;

        private Option(String name, @Nullable String valueDescription, String description, boolean optionalValue) {
            this.name = name;
            this.description = description;
            this.valueDescription = valueDescription;
            this.optionalValue = optionalValue;
        }

        String getName() {
            return this.name;
        }

        @Nullable String getValueDescription() {
            return this.valueDescription;
        }

        String getNameAndValueDescription() {
            return this.name + (String)(this.valueDescription != null ? " " + this.valueDescription : "");
        }

        String getDescription() {
            return this.description;
        }

        private @Nullable String claimArg(Deque<String> args) {
            if (this.valueDescription == null) {
                return null;
            }
            if (this.optionalValue) {
                String nextArg = args.peek();
                return nextArg != null && !nextArg.startsWith("--") ? args.removeFirst() : null;
            }
            try {
                return args.removeFirst();
            }
            catch (NoSuchElementException ex) {
                throw new MissingValueException(this.name);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.name.equals(((Option)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        static Option flag(String name, String description) {
            return new Option(name, null, description, false);
        }

        static Option of(String name, String valueDescription, String description) {
            return new Option(name, valueDescription, description, false);
        }

        static Option of(String name, String valueDescription, String description, boolean optionalValue) {
            return new Option(name, valueDescription, description, optionalValue);
        }
    }
}

