/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.springframework.boot.jarmode.tools.JarStructure;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class IndexedJarStructure
implements JarStructure {
    private static final List<String> MANIFEST_DENY_LIST = List.of("Start-Class", "Spring-Boot-Classes", "Spring-Boot-Lib", "Spring-Boot-Classpath-Index", "Spring-Boot-Layers-Index");
    private static final Set<String> ENTRY_IGNORE_LIST = Set.of("META-INF/", "META-INF/MANIFEST.MF", "META-INF/services/java.nio.file.spi.FileSystemProvider");
    private final Manifest originalManifest;
    private final String libLocation;
    private final String classesLocation;
    private final List<String> classpathEntries;

    IndexedJarStructure(Manifest originalManifest, String indexFile) {
        this.originalManifest = originalManifest;
        this.libLocation = IndexedJarStructure.getLocation(originalManifest, "Spring-Boot-Lib");
        this.classesLocation = IndexedJarStructure.getLocation(originalManifest, "Spring-Boot-Classes");
        this.classpathEntries = IndexedJarStructure.readIndexFile(indexFile);
    }

    private static String getLocation(Manifest manifest, String attribute) {
        String location = IndexedJarStructure.getMandatoryAttribute(manifest, attribute);
        return !location.endsWith("/") ? location + "/" : location;
    }

    private static List<String> readIndexFile(String indexFile) {
        String[] lines = (String[])Arrays.stream(indexFile.split("\n")).map(line -> line.replace("\r", "")).filter(StringUtils::hasText).toArray(String[]::new);
        ArrayList<String> classpathEntries = new ArrayList<String>();
        for (String line2 : lines) {
            Assert.state((boolean)line2.startsWith("- "), (String)"Classpath index file is malformed");
            classpathEntries.add(line2.substring(3, line2.length() - 1));
        }
        Assert.state((!classpathEntries.isEmpty() ? 1 : 0) != 0, (String)"Empty classpath index file loaded");
        return classpathEntries;
    }

    @Override
    public String getClassesLocation() {
        return this.classesLocation;
    }

    @Override
    public JarStructure.Entry resolve(String name) {
        if (ENTRY_IGNORE_LIST.contains(name)) {
            return null;
        }
        if (this.classpathEntries.contains(name)) {
            return new JarStructure.Entry(name, this.toStructureDependency(name), JarStructure.Entry.Type.LIBRARY);
        }
        if (name.startsWith(this.classesLocation)) {
            return new JarStructure.Entry(name, name.substring(this.classesLocation.length()), JarStructure.Entry.Type.APPLICATION_CLASS_OR_RESOURCE);
        }
        if (name.startsWith("org/springframework/boot/loader")) {
            return new JarStructure.Entry(name, name, JarStructure.Entry.Type.LOADER);
        }
        if (name.startsWith("META-INF/")) {
            return new JarStructure.Entry(name, name, JarStructure.Entry.Type.META_INF);
        }
        return null;
    }

    @Override
    public Manifest createLauncherManifest(UnaryOperator<String> libraryTransformer) {
        Manifest manifest = new Manifest(this.originalManifest);
        Attributes attributes = manifest.getMainAttributes();
        for (String denied : MANIFEST_DENY_LIST) {
            attributes.remove(new Attributes.Name(denied));
        }
        attributes.put(Attributes.Name.MAIN_CLASS, IndexedJarStructure.getMandatoryAttribute(this.originalManifest, "Start-Class"));
        attributes.put(Attributes.Name.CLASS_PATH, this.classpathEntries.stream().map(this::toStructureDependency).map(libraryTransformer).collect(Collectors.joining(" ")));
        return manifest;
    }

    private String toStructureDependency(String libEntryName) {
        Assert.state((boolean)libEntryName.startsWith(this.libLocation), () -> "Invalid library location " + libEntryName);
        return libEntryName.substring(this.libLocation.length());
    }

    private static String getMandatoryAttribute(Manifest manifest, String attribute) {
        String value = manifest.getMainAttributes().getValue(attribute);
        Assert.state((value != null ? 1 : 0) != 0, () -> "Manifest attribute '" + attribute + "' is mandatory");
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IndexedJarStructure get(File file) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            String location = IndexedJarStructure.getMandatoryAttribute(manifest, "Spring-Boot-Classpath-Index");
            ZipEntry entry = jarFile.getEntry(location);
            if (entry == null) return null;
            String indexFile = StreamUtils.copyToString((InputStream)jarFile.getInputStream(entry), (Charset)StandardCharsets.UTF_8);
            IndexedJarStructure indexedJarStructure = new IndexedJarStructure(manifest, indexFile);
            return indexedJarStructure;
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            return null;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

