/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.PrintStream;
import java.util.List;
import org.springframework.boot.jarmode.tools.Command;
import org.springframework.boot.jarmode.tools.Context;
import org.springframework.boot.jarmode.tools.ExtractCommand;
import org.springframework.boot.jarmode.tools.ListLayersCommand;
import org.springframework.boot.jarmode.tools.Runner;
import org.springframework.boot.loader.jarmode.JarMode;

public class ToolsJarMode
implements JarMode {
    private final Context context;
    private final PrintStream out;

    public ToolsJarMode() {
        this(null, null);
    }

    public ToolsJarMode(Context context, PrintStream out) {
        this.context = context != null ? context : new Context();
        this.out = out != null ? out : System.out;
    }

    public boolean accepts(String mode) {
        return "tools".equalsIgnoreCase(mode);
    }

    public void run(String mode, String[] args) {
        try {
            new Runner(this.out, this.context, ToolsJarMode.getCommands(this.context)).run(args);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static List<Command> getCommands(Context context) {
        return List.of(new ExtractCommand(context), new ListLayersCommand(context));
    }
}

