/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.springframework.boot.jarmode.layertools.Command;
import org.springframework.boot.jarmode.layertools.Context;
import org.springframework.boot.jarmode.layertools.ExtractCommand;
import org.springframework.boot.jarmode.layertools.HelpCommand;
import org.springframework.boot.jarmode.layertools.ListCommand;
import org.springframework.boot.loader.jarmode.JarMode;

public class LayerToolsJarMode
implements JarMode {
    public boolean accepts(String mode) {
        return "layertools".equalsIgnoreCase(mode);
    }

    public void run(String mode, String[] args) {
        try {
            new Runner().run(args);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class Runner {
        static Context contextOverride;
        private final List<Command> commands;
        private final HelpCommand help;

        Runner() {
            Context context = contextOverride != null ? contextOverride : new Context();
            this.commands = Runner.getCommands(context);
            this.help = new HelpCommand(context, this.commands);
        }

        private void run(String[] args) {
            this.run(new ArrayDeque<String>(Arrays.asList(args)));
        }

        private void run(Deque<String> args) {
            Command command;
            if (!args.isEmpty() && (command = Command.find(this.commands, args.removeFirst())) != null) {
                command.run(args);
                return;
            }
            this.help.run(args);
        }

        static List<Command> getCommands(Context context) {
            ArrayList<Command> commands = new ArrayList<Command>();
            commands.add(new ListCommand(context));
            commands.add(new ExtractCommand(context));
            return Collections.unmodifiableList(commands);
        }
    }
}

