/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson.autoconfigure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.JsonWriteFeature;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.cfg.JsonNodeFeature;

@ConfigurationProperties(value="spring.jackson")
public class JacksonProperties {
    private @Nullable String dateFormat;
    private @Nullable String propertyNamingStrategy;
    private final Map<PropertyAccessor, JsonAutoDetect.Visibility> visibility = new EnumMap<PropertyAccessor, JsonAutoDetect.Visibility>(PropertyAccessor.class);
    private final Map<SerializationFeature, Boolean> serialization = new EnumMap<SerializationFeature, Boolean>(SerializationFeature.class);
    private final Map<DeserializationFeature, Boolean> deserialization = new EnumMap<DeserializationFeature, Boolean>(DeserializationFeature.class);
    private final Map<MapperFeature, Boolean> mapper = new EnumMap<MapperFeature, Boolean>(MapperFeature.class);
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable JsonInclude.Include defaultPropertyInclusion;
    private @Nullable Boolean defaultLeniency;
    private @Nullable ConstructorDetectorStrategy constructorDetector;
    private @Nullable TimeZone timeZone;
    private @Nullable Locale locale;
    private boolean useJackson2Defaults;
    private boolean findAndAddModules = true;
    private final Datatype datatype = new Datatype();
    private final Map<StreamReadFeature, Boolean> read = new EnumMap<StreamReadFeature, Boolean>(StreamReadFeature.class);
    private final Map<StreamWriteFeature, Boolean> write = new EnumMap<StreamWriteFeature, Boolean>(StreamWriteFeature.class);
    private final Json json = new Json();
    private final Factory factory = new Factory();

    public @Nullable String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(@Nullable String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public @Nullable String getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public void setPropertyNamingStrategy(@Nullable String propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
    }

    public Map<PropertyAccessor, JsonAutoDetect.Visibility> getVisibility() {
        return this.visibility;
    }

    public Map<SerializationFeature, Boolean> getSerialization() {
        return this.serialization;
    }

    public Map<DeserializationFeature, Boolean> getDeserialization() {
        return this.deserialization;
    }

    public Map<MapperFeature, Boolean> getMapper() {
        return this.mapper;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable JsonInclude.Include getDefaultPropertyInclusion() {
        return this.defaultPropertyInclusion;
    }

    public void setDefaultPropertyInclusion(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable JsonInclude.Include defaultPropertyInclusion) {
        this.defaultPropertyInclusion = defaultPropertyInclusion;
    }

    public @Nullable Boolean getDefaultLeniency() {
        return this.defaultLeniency;
    }

    public void setDefaultLeniency(@Nullable Boolean defaultLeniency) {
        this.defaultLeniency = defaultLeniency;
    }

    public @Nullable ConstructorDetectorStrategy getConstructorDetector() {
        return this.constructorDetector;
    }

    public void setConstructorDetector(@Nullable ConstructorDetectorStrategy constructorDetector) {
        this.constructorDetector = constructorDetector;
    }

    public @Nullable TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(@Nullable TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public @Nullable Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@Nullable Locale locale) {
        this.locale = locale;
    }

    public boolean isUseJackson2Defaults() {
        return this.useJackson2Defaults;
    }

    public void setUseJackson2Defaults(boolean useJackson2Defaults) {
        this.useJackson2Defaults = useJackson2Defaults;
    }

    public boolean isFindAndAddModules() {
        return this.findAndAddModules;
    }

    public void setFindAndAddModules(boolean findModules) {
        this.findAndAddModules = findModules;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public Map<StreamReadFeature, Boolean> getRead() {
        return this.read;
    }

    public Map<StreamWriteFeature, Boolean> getWrite() {
        return this.write;
    }

    public Json getJson() {
        return this.json;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public static class Datatype {
        private final Map<EnumFeature, Boolean> enumFeatures = new EnumMap<EnumFeature, Boolean>(EnumFeature.class);
        private final Map<JsonNodeFeature, Boolean> jsonNode = new EnumMap<JsonNodeFeature, Boolean>(JsonNodeFeature.class);
        private final Map<DateTimeFeature, Boolean> datetime = new EnumMap<DateTimeFeature, Boolean>(DateTimeFeature.class);

        public Map<EnumFeature, Boolean> getEnum() {
            return this.enumFeatures;
        }

        public Map<JsonNodeFeature, Boolean> getJsonNode() {
            return this.jsonNode;
        }

        public Map<DateTimeFeature, Boolean> getDatetime() {
            return this.datetime;
        }
    }

    public static class Json {
        private final Map<JsonReadFeature, Boolean> read = new EnumMap<JsonReadFeature, Boolean>(JsonReadFeature.class);
        private final Map<JsonWriteFeature, Boolean> write = new EnumMap<JsonWriteFeature, Boolean>(JsonWriteFeature.class);

        public Map<JsonReadFeature, Boolean> getRead() {
            return this.read;
        }

        public Map<JsonWriteFeature, Boolean> getWrite() {
            return this.write;
        }
    }

    public static class Factory {
        private final Constraints constraints = new Constraints();

        public Constraints getConstraints() {
            return this.constraints;
        }

        public static class Constraints {
            private final Read read = new Read();
            private final Write write = new Write();

            public Read getRead() {
                return this.read;
            }

            public Write getWrite() {
                return this.write;
            }

            public static class Read {
                private int maxNestingDepth = 500;
                private long maxDocumentLength = -1L;
                private long maxTokenCount = -1L;
                private int maxNumberLength = 1000;
                private int maxStringLength = 20000000;
                private int maxNameLength = 50000;

                public int getMaxNestingDepth() {
                    return this.maxNestingDepth;
                }

                public void setMaxNestingDepth(int maxNestingDepth) {
                    this.maxNestingDepth = maxNestingDepth;
                }

                public long getMaxDocumentLength() {
                    return this.maxDocumentLength;
                }

                public void setMaxDocumentLength(long maxDocumentLength) {
                    this.maxDocumentLength = maxDocumentLength;
                }

                public long getMaxTokenCount() {
                    return this.maxTokenCount;
                }

                public void setMaxTokenCount(long maxTokenCount) {
                    this.maxTokenCount = maxTokenCount;
                }

                public int getMaxNumberLength() {
                    return this.maxNumberLength;
                }

                public void setMaxNumberLength(int maxNumberLength) {
                    this.maxNumberLength = maxNumberLength;
                }

                public int getMaxStringLength() {
                    return this.maxStringLength;
                }

                public void setMaxStringLength(int maxStringLength) {
                    this.maxStringLength = maxStringLength;
                }

                public int getMaxNameLength() {
                    return this.maxNameLength;
                }

                public void setMaxNameLength(int maxNameLength) {
                    this.maxNameLength = maxNameLength;
                }
            }

            public static class Write {
                private int maxNestingDepth = 500;

                public int getMaxNestingDepth() {
                    return this.maxNestingDepth;
                }

                public void setMaxNestingDepth(int maxNestingDepth) {
                    this.maxNestingDepth = maxNestingDepth;
                }
            }
        }
    }

    public static enum ConstructorDetectorStrategy {
        DEFAULT,
        USE_PROPERTIES_BASED,
        USE_DELEGATING,
        EXPLICIT_ONLY;

    }
}

