/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.integration.autoconfigure;

import io.rsocket.RSocket;
import io.rsocket.transport.netty.server.TcpServerTransport;
import java.time.Duration;
import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxProperties;
import org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.MutuallyExclusiveConfigurationPropertiesException;
import org.springframework.boot.integration.autoconfigure.IntegrationAutoConfigurationScanRegistrar;
import org.springframework.boot.integration.autoconfigure.IntegrationDataSourceScriptDatabaseInitializer;
import org.springframework.boot.integration.autoconfigure.IntegrationJdbcProperties;
import org.springframework.boot.integration.autoconfigure.IntegrationProperties;
import org.springframework.boot.integration.autoconfigure.PollerMetadataCustomizer;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.sql.autoconfigure.init.OnDatabaseInitializationCondition;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerBuilder;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.boot.thread.Threading;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.config.IntegrationComponentScanRegistrar;
import org.springframework.integration.config.IntegrationManagementConfigurer;
import org.springframework.integration.jdbc.store.JdbcMessageStore;
import org.springframework.integration.jmx.config.EnableIntegrationMBeanExport;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.integration.rsocket.ClientRSocketConnector;
import org.springframework.integration.rsocket.IntegrationRSocketEndpoint;
import org.springframework.integration.rsocket.ServerRSocketConnector;
import org.springframework.integration.rsocket.ServerRSocketMessageHandler;
import org.springframework.integration.rsocket.outbound.RSocketOutboundGateway;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.StringUtils;

@AutoConfiguration(beforeName={"org.springframework.boot.rsocket.autoconfigure.RSocketMessagingAutoConfiguration"}, after={JmxAutoConfiguration.class, TaskSchedulingAutoConfiguration.class}, afterName={"org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration"})
@ConditionalOnClass(value={EnableIntegration.class})
@EnableConfigurationProperties(value={IntegrationProperties.class, JmxProperties.class})
public final class IntegrationAutoConfiguration {
    @Bean(name={"integrationGlobalProperties"})
    @ConditionalOnMissingBean(name={"integrationGlobalProperties"})
    static org.springframework.integration.context.IntegrationProperties integrationGlobalProperties(IntegrationProperties properties) {
        org.springframework.integration.context.IntegrationProperties integrationProperties = new org.springframework.integration.context.IntegrationProperties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from((Object)properties.getChannel().isAutoCreate()).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setChannelsAutoCreate(arg_0));
        map.from((Object)properties.getChannel().getMaxUnicastSubscribers()).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setChannelsMaxUnicastSubscribers(arg_0));
        map.from((Object)properties.getChannel().getMaxBroadcastSubscribers()).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setChannelsMaxBroadcastSubscribers(arg_0));
        map.from((Object)properties.getError().isRequireSubscribers()).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setErrorChannelRequireSubscribers(arg_0));
        map.from((Object)properties.getError().isIgnoreFailures()).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setErrorChannelIgnoreFailures(arg_0));
        map.from((Object)properties.getEndpoint().isThrowExceptionOnLateReply()).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setMessagingTemplateThrowExceptionOnLateReply(arg_0));
        map.from((Object)properties.getEndpoint().getDefaultTimeout()).as(Duration::toMillis).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setEndpointsDefaultTimeout(arg_0));
        map.from(properties.getEndpoint().getReadOnlyHeaders()).as(StringUtils::toStringArray).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setReadOnlyHeaders(arg_0));
        map.from(properties.getEndpoint().getNoAutoStartup()).as(StringUtils::toStringArray).to(arg_0 -> ((org.springframework.integration.context.IntegrationProperties)integrationProperties).setNoAutoStartupEndpoints(arg_0));
        return integrationProperties;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={IntegrationRSocketEndpoint.class, RSocketRequester.class, RSocket.class})
    @Conditional(value={AnyRSocketChannelAdapterAvailable.class})
    protected static class IntegrationRSocketConfiguration {
        protected IntegrationRSocketConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        protected static class IntegrationRSocketClientConfiguration {
            protected IntegrationRSocketClientConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            @Conditional(value={RemoteRSocketServerAddressConfigured.class})
            ClientRSocketConnector clientRSocketConnector(IntegrationProperties integrationProperties, RSocketStrategies rSocketStrategies) {
                ClientRSocketConnector clientRSocketConnector;
                IntegrationProperties.RSocket.Client client = integrationProperties.getRsocket().getClient();
                if (client.getUri() != null) {
                    clientRSocketConnector = new ClientRSocketConnector(client.getUri());
                } else if (client.getHost() != null && client.getPort() != null) {
                    clientRSocketConnector = new ClientRSocketConnector(client.getHost(), client.getPort().intValue());
                } else {
                    throw new IllegalStateException("Neither uri nor host and port is set");
                }
                clientRSocketConnector.setRSocketStrategies(rSocketStrategies);
                return clientRSocketConnector;
            }

            static class RemoteRSocketServerAddressConfigured
            extends AnyNestedCondition {
                RemoteRSocketServerAddressConfigured() {
                    super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
                }

                @ConditionalOnProperty(value={"spring.integration.rsocket.client.host", "spring.integration.rsocket.client.port"})
                static class TcpAddressConfigured {
                    TcpAddressConfigured() {
                    }
                }

                @ConditionalOnProperty(value={"spring.integration.rsocket.client.uri"})
                static class WebSocketAddressConfigured {
                    WebSocketAddressConfigured() {
                    }
                }
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={TcpServerTransport.class})
        protected static class IntegrationRSocketServerConfiguration {
            protected IntegrationRSocketServerConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean(value={ServerRSocketMessageHandler.class})
            RSocketMessageHandler serverRSocketMessageHandler(RSocketStrategies rSocketStrategies, IntegrationProperties integrationProperties) {
                ServerRSocketMessageHandler messageHandler = new ServerRSocketMessageHandler(integrationProperties.getRsocket().getServer().isMessageMappingEnabled());
                messageHandler.setRSocketStrategies(rSocketStrategies);
                return messageHandler;
            }

            @Bean
            @ConditionalOnMissingBean
            ServerRSocketConnector serverRSocketConnector(ServerRSocketMessageHandler messageHandler) {
                return new ServerRSocketConnector(messageHandler);
            }
        }

        static class AnyRSocketChannelAdapterAvailable
        extends AnyNestedCondition {
            AnyRSocketChannelAdapterAvailable() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnBean(value={RSocketOutboundGateway.class})
            static class RSocketOutboundGatewayAvailable {
                RSocketOutboundGatewayAvailable() {
                }
            }

            @ConditionalOnBean(value={IntegrationRSocketEndpoint.class})
            static class IntegrationRSocketEndpointAvailable {
                IntegrationRSocketEndpointAvailable() {
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=DataSource.class)
    @ConditionalOnClass(value={JdbcMessageStore.class, DataSourceScriptDatabaseInitializer.class})
    @EnableConfigurationProperties(value={IntegrationJdbcProperties.class})
    protected static class IntegrationJdbcConfiguration {
        protected IntegrationJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Conditional(value={OnIntegrationDatasourceInitializationCondition.class})
        IntegrationDataSourceScriptDatabaseInitializer integrationDataSourceInitializer(DataSource dataSource, IntegrationJdbcProperties properties) {
            return new IntegrationDataSourceScriptDatabaseInitializer(dataSource, properties);
        }

        static class OnIntegrationDatasourceInitializationCondition
        extends OnDatabaseInitializationCondition {
            OnIntegrationDatasourceInitializationCondition() {
                super("Integration", new String[]{"spring.integration.jdbc.initialize-schema"});
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={IntegrationComponentScanRegistrar.class})
    @Import(value={IntegrationAutoConfigurationScanRegistrar.class})
    protected static class IntegrationComponentScanConfiguration {
        protected IntegrationComponentScanConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnableIntegrationManagement.class})
    @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
    protected static class IntegrationManagementConfiguration {
        protected IntegrationManagementConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @EnableIntegrationManagement(defaultLoggingEnabled="${spring.integration.management.default-logging-enabled:true}", observationPatterns={"${spring.integration.management.observation-patterns:}"})
        protected static class EnableIntegrationManagementConfiguration {
            protected EnableIntegrationManagementConfiguration() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationMBeanExporter.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnBean(value={MBeanServer.class})
    @ConditionalOnBooleanProperty(value={"spring.jmx.enabled"})
    protected static class IntegrationJmxConfiguration {
        protected IntegrationJmxConfiguration() {
        }

        @Bean
        static IntegrationMBeanExporter integrationMbeanExporter(final ApplicationContext applicationContext) {
            return new IntegrationMBeanExporter(){

                public void afterSingletonsInstantiated() {
                    JmxProperties properties = (JmxProperties)applicationContext.getBean(JmxProperties.class);
                    String defaultDomain = properties.getDefaultDomain();
                    if (StringUtils.hasLength((String)defaultDomain)) {
                        this.setDefaultDomain(defaultDomain);
                    }
                    this.setServer((MBeanServer)applicationContext.getBean(properties.getServer(), MBeanServer.class));
                    super.afterSingletonsInstantiated();
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(name={"taskScheduler"})
    protected static class IntegrationTaskSchedulerConfiguration {
        protected IntegrationTaskSchedulerConfiguration() {
        }

        @Bean(name={"taskScheduler"})
        @ConditionalOnBean(value={ThreadPoolTaskSchedulerBuilder.class})
        @ConditionalOnThreading(value=Threading.PLATFORM)
        ThreadPoolTaskScheduler taskScheduler(ThreadPoolTaskSchedulerBuilder threadPoolTaskSchedulerBuilder) {
            return threadPoolTaskSchedulerBuilder.build();
        }

        @Bean(name={"taskScheduler"})
        @ConditionalOnBean(value={SimpleAsyncTaskSchedulerBuilder.class})
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskScheduler taskSchedulerVirtualThreads(SimpleAsyncTaskSchedulerBuilder simpleAsyncTaskSchedulerBuilder) {
            return simpleAsyncTaskSchedulerBuilder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableIntegration
    protected static class IntegrationConfiguration {
        protected IntegrationConfiguration() {
        }

        @Bean(value={"org.springframework.integration.context.defaultPollerMetadata"})
        @ConditionalOnMissingBean(name={"org.springframework.integration.context.defaultPollerMetadata"})
        PollerMetadata defaultPollerMetadata(IntegrationProperties integrationProperties, ObjectProvider<PollerMetadataCustomizer> customizers) {
            IntegrationProperties.Poller poller = integrationProperties.getPoller();
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleNonNullValuesIn(entries -> {
                entries.put("spring.integration.poller.cron", StringUtils.hasText((String)poller.getCron()) ? poller.getCron() : null);
                entries.put("spring.integration.poller.fixed-delay", poller.getFixedDelay());
                entries.put("spring.integration.poller.fixed-rate", poller.getFixedRate());
            });
            PollerMetadata pollerMetadata = new PollerMetadata();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(poller::getMaxMessagesPerPoll).to(arg_0 -> ((PollerMetadata)pollerMetadata).setMaxMessagesPerPoll(arg_0));
            map.from(poller::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((PollerMetadata)pollerMetadata).setReceiveTimeout(arg_0));
            this.setTrigger(map, poller, pollerMetadata);
            customizers.orderedStream().forEach(customizer -> customizer.customize(pollerMetadata));
            return pollerMetadata;
        }

        private void setTrigger(PropertyMapper map, IntegrationProperties.Poller poller, PollerMetadata pollerMetadata) {
            map.from((Object)poller).as(this::asTrigger).to(arg_0 -> ((PollerMetadata)pollerMetadata).setTrigger(arg_0));
        }

        private @Nullable Trigger asTrigger(IntegrationProperties.Poller poller) {
            if (StringUtils.hasText((String)poller.getCron())) {
                return new CronTrigger(poller.getCron());
            }
            if (poller.getFixedDelay() != null) {
                return this.createPeriodicTrigger(poller.getFixedDelay(), poller.getInitialDelay(), false);
            }
            if (poller.getFixedRate() != null) {
                return this.createPeriodicTrigger(poller.getFixedRate(), poller.getInitialDelay(), true);
            }
            return null;
        }

        private Trigger createPeriodicTrigger(Duration period, @Nullable Duration initialDelay, boolean fixedRate) {
            PeriodicTrigger trigger = new PeriodicTrigger(period);
            if (initialDelay != null) {
                trigger.setInitialDelay(initialDelay);
            }
            trigger.setFixedRate(fixedRate);
            return trigger;
        }
    }
}

