/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.http.client.reactive.HttpComponentsClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.JdkClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.JettyClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ReactorClientHttpConnectorBuilder;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;
import org.springframework.http.client.reactive.JdkClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;

@FunctionalInterface
public interface ClientHttpConnectorBuilder<T extends ClientHttpConnector> {
    default public T build() {
        return this.build(null);
    }

    public T build(@Nullable ClientHttpConnectorSettings var1);

    default public ClientHttpConnectorBuilder<T> withCustomizer(Consumer<T> customizer) {
        return this.withCustomizers(List.of(customizer));
    }

    default public ClientHttpConnectorBuilder<T> withCustomizers(Collection<Consumer<T>> customizers) {
        Assert.notNull(customizers, (String)"'customizers' must not be null");
        Assert.noNullElements(customizers, (String)"'customizers' must not contain null elements");
        return settings -> {
            Object factory = this.build(settings);
            LambdaSafe.callbacks(Consumer.class, (Collection)customizers, factory, (Object[])new Object[0]).invoke(consumer -> consumer.accept(factory));
            return factory;
        };
    }

    public static HttpComponentsClientHttpConnectorBuilder httpComponents() {
        return new HttpComponentsClientHttpConnectorBuilder();
    }

    public static JettyClientHttpConnectorBuilder jetty() {
        return new JettyClientHttpConnectorBuilder();
    }

    public static ReactorClientHttpConnectorBuilder reactor() {
        return new ReactorClientHttpConnectorBuilder();
    }

    public static JdkClientHttpConnectorBuilder jdk() {
        return new JdkClientHttpConnectorBuilder();
    }

    public static <T extends ClientHttpConnector> ClientHttpConnectorBuilder<T> of(Class<T> clientHttpConnectorType) {
        Assert.notNull(clientHttpConnectorType, (String)"'requestFactoryType' must not be null");
        Assert.isTrue((clientHttpConnectorType != ClientHttpConnector.class ? 1 : 0) != 0, (String)"'clientHttpConnectorType' must be an implementation of ClientHttpConnector");
        if (clientHttpConnectorType == ReactorClientHttpConnector.class) {
            return ClientHttpConnectorBuilder.reactor();
        }
        if (clientHttpConnectorType == JettyClientHttpConnector.class) {
            return ClientHttpConnectorBuilder.jetty();
        }
        if (clientHttpConnectorType == HttpComponentsClientHttpConnector.class) {
            return ClientHttpConnectorBuilder.httpComponents();
        }
        if (clientHttpConnectorType == JdkClientHttpConnector.class) {
            return ClientHttpConnectorBuilder.jdk();
        }
        throw new IllegalArgumentException("'clientHttpConnectorType' %s is not supported".formatted(clientHttpConnectorType.getName()));
    }

    public static ClientHttpConnectorBuilder<? extends ClientHttpConnector> detect() {
        return ClientHttpConnectorBuilder.detect(null);
    }

    public static ClientHttpConnectorBuilder<? extends ClientHttpConnector> detect(@Nullable ClassLoader classLoader) {
        if (ReactorClientHttpConnectorBuilder.Classes.present(classLoader)) {
            return ClientHttpConnectorBuilder.reactor();
        }
        if (JettyClientHttpConnectorBuilder.Classes.present(classLoader)) {
            return ClientHttpConnectorBuilder.jetty();
        }
        if (HttpComponentsClientHttpConnectorBuilder.Classes.present(classLoader)) {
            return ClientHttpConnectorBuilder.httpComponents();
        }
        if (JdkClientHttpConnectorBuilder.Classes.present(classLoader)) {
            return ClientHttpConnectorBuilder.jdk();
        }
        throw new IllegalStateException("Unable to detect any ClientHttpConnectorBuilder");
    }
}

