/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.reactive;

import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationPropertiesSource;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;

@ConfigurationPropertiesSource
public abstract class AbstractClientHttpConnectorProperties {
    private @Nullable HttpRedirects redirects;
    private @Nullable Duration connectTimeout;
    private @Nullable Duration readTimeout;
    private final Ssl ssl = new Ssl();
    private @Nullable Connector connector;

    public @Nullable HttpRedirects getRedirects() {
        return this.redirects;
    }

    public void setRedirects(@Nullable HttpRedirects redirects) {
        this.redirects = redirects;
    }

    public @Nullable Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(@Nullable Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public @Nullable Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(@Nullable Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public @Nullable Connector getConnector() {
        return this.connector;
    }

    public void setConnector(@Nullable Connector connector) {
        this.connector = connector;
    }

    @ConfigurationPropertiesSource
    public static class Ssl {
        private @Nullable String bundle;

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }
    }

    public static enum Connector {
        REACTOR(ClientHttpConnectorBuilder::reactor),
        JETTY(ClientHttpConnectorBuilder::jetty),
        HTTP_COMPONENTS(ClientHttpConnectorBuilder::httpComponents),
        JDK(ClientHttpConnectorBuilder::jdk);

        private final Supplier<ClientHttpConnectorBuilder<?>> builderSupplier;

        private Connector(Supplier<ClientHttpConnectorBuilder<?>> builderSupplier) {
            this.builderSupplier = builderSupplier;
        }

        ClientHttpConnectorBuilder<?> builder() {
            return this.builderSupplier.get();
        }
    }
}

