/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.JdkClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.autoconfigure.ClientHttpRequestFactories;
import org.springframework.boot.http.client.autoconfigure.ClientHttpRequestFactoryBuilderCustomizer;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.http.client.autoconfigure.NotReactiveWebApplicationCondition;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.http.client.ClientHttpRequestFactory;

@AutoConfiguration(after={SslAutoConfiguration.class})
@ConditionalOnClass(value={ClientHttpRequestFactory.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={HttpClientProperties.class})
public final class HttpClientAutoConfiguration
implements BeanClassLoaderAware {
    private final ClientHttpRequestFactories factories;
    private final Environment environment;
    private ClassLoader beanClassLoader;

    HttpClientAutoConfiguration(Environment environment, ObjectProvider<SslBundles> sslBundles, HttpClientProperties properties) {
        this.environment = environment;
        this.factories = new ClientHttpRequestFactories((ObjectFactory<SslBundles>)sslBundles, properties);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilderOnPlatform(ObjectProvider<ClientHttpRequestFactoryBuilderCustomizer<?>> clientHttpRequestFactoryBuilderCustomizers) {
        JdkClientHttpRequestFactoryBuilder builder = this.factories.builder(this.beanClassLoader);
        if (builder instanceof JdkClientHttpRequestFactoryBuilder) {
            JdkClientHttpRequestFactoryBuilder jdk = builder;
            if (Threading.VIRTUAL.isActive(this.environment)) {
                builder = jdk.withExecutor((Executor)new VirtualThreadTaskExecutor("httpclient-"));
            }
        }
        return this.customize(builder, clientHttpRequestFactoryBuilderCustomizers.orderedStream().toList());
    }

    private ClientHttpRequestFactoryBuilder<?> customize(ClientHttpRequestFactoryBuilder<?> builder, List<ClientHttpRequestFactoryBuilderCustomizer<?>> customizers) {
        ClientHttpRequestFactoryBuilder[] builderReference = new ClientHttpRequestFactoryBuilder[]{builder};
        LambdaSafe.callbacks(ClientHttpRequestFactoryBuilderCustomizer.class, customizers, (Object)builderReference[0], (Object[])new Object[0]).invoke(customizer -> {
            builderReference[0] = customizer.customize(builderReference[0]);
        });
        return builderReference[0];
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpRequestFactorySettings clientHttpRequestFactorySettings() {
        return this.factories.settings();
    }
}

