/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.health.actuate.endpoint;

/**
 * Hook that allows for custom modification of {@link HealthEndpointGroups} &mdash; for
 * example, automatically adding additional auto-configured groups.
 *
 * @author Phillip Webb
 * @author Brian Clozel
 * @since 4.0.0
 */
@FunctionalInterface
public interface HealthEndpointGroupsPostProcessor {

	/**
	 * Post-process the given {@link HealthEndpointGroups} instance.
	 * @param groups the existing groups instance
	 * @return a post-processed groups instance, or the original instance if not
	 * post-processing was required
	 */
	HealthEndpointGroups postProcessHealthEndpointGroups(HealthEndpointGroups groups);

}
