/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.application;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.health.application.SslHealthIndicator;
import org.springframework.boot.health.autoconfigure.application.SslHealthIndicatorProperties;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.HealthContributorAutoConfiguration;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.info.SslInfo;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={HealthContributorAutoConfiguration.class})
@ConditionalOnClass(value={Health.class})
@ConditionalOnEnabledHealthIndicator(value="ssl")
@EnableConfigurationProperties(value={SslHealthIndicatorProperties.class})
public final class SslHealthContributorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"sslHealthIndicator"})
    SslHealthIndicator sslHealthIndicator(SslInfo sslInfo, SslHealthIndicatorProperties properties) {
        return new SslHealthIndicator(sslInfo, properties.getCertificateValidityWarningThreshold());
    }

    @Bean
    @ConditionalOnMissingBean
    SslInfo sslInfo(SslBundles sslBundles) {
        return new SslInfo(sslBundles);
    }
}

