/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.contributor.CompositeHealthContributor;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.util.Assert;

class MapCompositeHealthContributor<V>
implements CompositeHealthContributor {
    private final Map<String, HealthContributor> contributors;

    MapCompositeHealthContributor(Map<String, V> map, Function<V, ? extends HealthContributor> valueAdapter) {
        Assert.notNull(map, (String)"'map' must not be null");
        Assert.notNull(valueAdapter, (String)"'valueAdapter' must not be null");
        LinkedHashMap contributors = new LinkedHashMap();
        map.forEach((? super K key, ? super V value) -> {
            Assert.notNull((Object)key, (String)"'map' must not contain null keys");
            Assert.notNull((Object)value, (String)"'map' must not contain null values");
            Assert.isTrue((!key.contains("/") ? 1 : 0) != 0, (String)"'map' keys must not contain a '/'");
            contributors.put(key, (HealthContributor)valueAdapter.apply(value));
        });
        this.contributors = Collections.unmodifiableMap(contributors);
    }

    @Override
    public @Nullable HealthContributor getContributor(String name) {
        return this.contributors.get(name);
    }

    @Override
    public Stream<HealthContributors.Entry> stream() {
        return this.contributors.entrySet().stream().map(entry -> new HealthContributors.Entry((String)entry.getKey(), (HealthContributor)entry.getValue()));
    }
}

