/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.groovy.template.autoconfigure;

import groovy.text.markup.BaseTemplate;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

@ConfigurationProperties(value="spring.groovy.template")
public class GroovyTemplateProperties {
    public static final String DEFAULT_RESOURCE_LOADER_PATH = "classpath:/templates/";
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_SUFFIX = ".tpl";
    public static final String DEFAULT_REQUEST_CONTEXT_ATTRIBUTE = "spring";
    private static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf((String)"text/html");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private boolean enabled = true;
    private boolean cache;
    private MimeType contentType = DEFAULT_CONTENT_TYPE;
    private Charset charset = DEFAULT_CHARSET;
    private String @Nullable [] viewNames;
    private boolean checkTemplateLocation = true;
    private String prefix = "";
    private String suffix = ".tpl";
    private String requestContextAttribute = "spring";
    private boolean exposeRequestAttributes = false;
    private boolean exposeSessionAttributes = false;
    private boolean allowRequestOverride = false;
    private boolean exposeSpringMacroHelpers = true;
    private boolean allowSessionOverride = false;
    private boolean autoEscape;
    private boolean autoIndent;
    private @Nullable String autoIndentString;
    private boolean autoNewLine;
    private Class<? extends BaseTemplate> baseTemplateClass = BaseTemplate.class;
    private @Nullable String declarationEncoding;
    private boolean expandEmptyElements;
    private @Nullable Locale locale;
    private @Nullable String newLineString;
    private String resourceLoaderPath = "classpath:/templates/";
    private boolean useDoubleQuotes;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isCheckTemplateLocation() {
        return this.checkTemplateLocation;
    }

    public void setCheckTemplateLocation(boolean checkTemplateLocation) {
        this.checkTemplateLocation = checkTemplateLocation;
    }

    public String @Nullable [] getViewNames() {
        return this.viewNames;
    }

    public void setViewNames(String @Nullable [] viewNames) {
        this.viewNames = viewNames;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public MimeType getContentType() {
        if (this.contentType.getCharset() == null) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("charset", this.charset.name());
            parameters.putAll(this.contentType.getParameters());
            return new MimeType(this.contentType, parameters);
        }
        return this.contentType;
    }

    public void setContentType(MimeType contentType) {
        this.contentType = contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public @Nullable String getCharsetName() {
        return this.charset != null ? this.charset.name() : null;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isAutoEscape() {
        return this.autoEscape;
    }

    public void setAutoEscape(boolean autoEscape) {
        this.autoEscape = autoEscape;
    }

    public boolean isAutoIndent() {
        return this.autoIndent;
    }

    public void setAutoIndent(boolean autoIndent) {
        this.autoIndent = autoIndent;
    }

    public @Nullable String getAutoIndentString() {
        return this.autoIndentString;
    }

    public void setAutoIndentString(@Nullable String autoIndentString) {
        this.autoIndentString = autoIndentString;
    }

    public boolean isAutoNewLine() {
        return this.autoNewLine;
    }

    public void setAutoNewLine(boolean autoNewLine) {
        this.autoNewLine = autoNewLine;
    }

    public Class<? extends BaseTemplate> getBaseTemplateClass() {
        return this.baseTemplateClass;
    }

    public void setBaseTemplateClass(Class<? extends BaseTemplate> baseTemplateClass) {
        this.baseTemplateClass = baseTemplateClass;
    }

    public @Nullable String getDeclarationEncoding() {
        return this.declarationEncoding;
    }

    public void setDeclarationEncoding(@Nullable String declarationEncoding) {
        this.declarationEncoding = declarationEncoding;
    }

    public boolean isExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public void setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
    }

    public @Nullable Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@Nullable Locale locale) {
        this.locale = locale;
    }

    public @Nullable String getNewLineString() {
        return this.newLineString;
    }

    public void setNewLineString(@Nullable String newLineString) {
        this.newLineString = newLineString;
    }

    public String getResourceLoaderPath() {
        return this.resourceLoaderPath;
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public boolean isUseDoubleQuotes() {
        return this.useDoubleQuotes;
    }

    public void setUseDoubleQuotes(boolean useDoubleQuotes) {
        this.useDoubleQuotes = useDoubleQuotes;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public boolean isExposeRequestAttributes() {
        return this.exposeRequestAttributes;
    }

    public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
        this.exposeRequestAttributes = exposeRequestAttributes;
    }

    public boolean isExposeSessionAttributes() {
        return this.exposeSessionAttributes;
    }

    public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
        this.exposeSessionAttributes = exposeSessionAttributes;
    }

    public boolean isAllowRequestOverride() {
        return this.allowRequestOverride;
    }

    public void setAllowRequestOverride(boolean allowRequestOverride) {
        this.allowRequestOverride = allowRequestOverride;
    }

    public boolean isAllowSessionOverride() {
        return this.allowSessionOverride;
    }

    public void setAllowSessionOverride(boolean allowSessionOverride) {
        this.allowSessionOverride = allowSessionOverride;
    }

    public boolean isExposeSpringMacroHelpers() {
        return this.exposeSpringMacroHelpers;
    }

    public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
        this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
    }

    public void applyToMvcViewResolver(Object viewResolver) {
        Assert.isInstanceOf(AbstractTemplateViewResolver.class, (Object)viewResolver, () -> "ViewResolver is not an instance of AbstractTemplateViewResolver :" + String.valueOf(viewResolver));
        AbstractTemplateViewResolver resolver = (AbstractTemplateViewResolver)viewResolver;
        resolver.setPrefix(this.getPrefix());
        resolver.setSuffix(this.getSuffix());
        resolver.setCache(this.isCache());
        MimeType contentType = this.getContentType();
        if (contentType != null) {
            resolver.setContentType(contentType.toString());
        }
        resolver.setViewNames(this.getViewNames());
        resolver.setExposeRequestAttributes(this.isExposeRequestAttributes());
        resolver.setAllowRequestOverride(this.isAllowRequestOverride());
        resolver.setAllowSessionOverride(this.isAllowSessionOverride());
        resolver.setExposeSessionAttributes(this.isExposeSessionAttributes());
        resolver.setExposeSpringMacroHelpers(this.isExposeSpringMacroHelpers());
        resolver.setRequestContextAttribute(this.getRequestContextAttribute());
        resolver.setOrder(0x7FFFFFFA);
    }
}

