/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.graphql.tester;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.graphql.tester.HttpGraphQlTesterContextCustomizer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ClassUtils;

class HttpGraphQlTesterContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final String HTTPGRAPHQLTESTER_CLASS = "org.springframework.graphql.test.tester.HttpGraphQlTester";
    private static final String WEBTESTCLIENT_CLASS = "org.springframework.test.web.reactive.server.WebTestClient";

    HttpGraphQlTesterContextCustomizerFactory() {
    }

    public @Nullable ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        SpringBootTest springBootTest = (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class);
        return springBootTest != null && this.isGraphQlTesterPresent() ? new HttpGraphQlTesterContextCustomizer() : null;
    }

    private boolean isGraphQlTesterPresent() {
        return ClassUtils.isPresent((String)WEBTESTCLIENT_CLASS, (ClassLoader)this.getClass().getClassLoader()) && ClassUtils.isPresent((String)HTTPGRAPHQLTESTER_CLASS, (ClassLoader)this.getClass().getClassLoader());
    }
}

