/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.gradle.api.Buildable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.bundling.BootWar;

final class SinglePublishedArtifact
implements Buildable {
    private final Configuration configuration;
    private final ArtifactHandler handler;
    private PublishArtifact currentArtifact;

    SinglePublishedArtifact(Configuration configuration, ArtifactHandler handler) {
        this.configuration = configuration;
        this.handler = handler;
    }

    void addWarCandidate(TaskProvider<BootWar> candidate) {
        this.add(candidate);
    }

    void addJarCandidate(TaskProvider<BootJar> candidate) {
        if (this.currentArtifact == null) {
            this.add(candidate);
        }
    }

    private void add(TaskProvider<? extends Jar> artifact) {
        this.configuration.getArtifacts().remove((Object)this.currentArtifact);
        this.currentArtifact = this.handler.add(this.configuration.getName(), artifact);
    }

    public TaskDependency getBuildDependencies() {
        return this.configuration.getArtifacts().getBuildDependencies();
    }
}

