/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

public class BootJar
extends Jar
implements BootArchive {
    private final BootArchiveSupport support = new BootArchiveSupport("org.springframework.boot.loader.JarLauncher", this::resolveZipCompression);
    private final CopySpec bootInf = this.getProject().copySpec().into((Object)"BOOT-INF");
    private String mainClassName;
    private FileCollection classpath;

    public BootJar() {
        this.getMainSpec().with(new CopySpec[]{this.bootInf});
        this.bootInf.into((Object)"classes", this.classpathFiles((Spec<File>)((Spec)File::isDirectory)));
        this.bootInf.into((Object)"lib", this.classpathFiles((Spec<File>)((Spec)File::isFile)));
        this.bootInf.filesMatching("module-info.class", details -> details.setRelativePath(details.getRelativeSourcePath()));
    }

    private Action<CopySpec> classpathFiles(Spec<File> filter) {
        return copySpec -> copySpec.from(new Object[]{() -> this.classpath != null ? this.classpath.filter(filter) : Collections.emptyList()});
    }

    public void copy() {
        this.support.configureManifest(this, this.getMainClassName());
        super.copy();
    }

    protected CopyAction createCopyAction() {
        return this.support.createCopyAction(this);
    }

    @Override
    public String getMainClassName() {
        String manifestStartClass;
        if (this.mainClassName == null && (manifestStartClass = (String)this.getManifest().getAttributes().get((Object)"Start-Class")) != null) {
            this.setMainClassName(manifestStartClass);
        }
        return this.mainClassName;
    }

    @Override
    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void classpath(Object ... classpath) {
        FileCollection existingClasspath = this.classpath;
        this.classpath = this.getProject().files(new Object[]{existingClasspath != null ? existingClasspath : Collections.emptyList(), classpath});
    }

    @Override
    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    public boolean isExcludeDevtools() {
        return this.support.isExcludeDevtools();
    }

    @Override
    public void setExcludeDevtools(boolean excludeDevtools) {
        this.support.setExcludeDevtools(excludeDevtools);
    }

    @Internal
    public CopySpec getBootInf() {
        CopySpec child = this.getProject().copySpec();
        this.bootInf.with(new CopySpec[]{child});
        return child;
    }

    public CopySpec bootInf(Action<CopySpec> action) {
        CopySpec bootInf = this.getBootInf();
        action.execute((Object)bootInf);
        return bootInf;
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        if (details.getRelativePath().getPathString().startsWith("BOOT-INF/lib/")) {
            return ZipCompression.STORED;
        }
        return ZipCompression.DEFLATED;
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration((AbstractArchiveTask)this);
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }
}

