/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.jvm.application.scripts.TemplateBasedScriptGenerator;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.tasks.application.CreateBootStartScripts;

final class ApplicationPluginAction
implements PluginApplicationAction {
    ApplicationPluginAction() {
    }

    public void execute(Project project) {
        ApplicationPluginConvention applicationConvention = (ApplicationPluginConvention)project.getConvention().getPlugin(ApplicationPluginConvention.class);
        DistributionContainer distributions = (DistributionContainer)project.getExtensions().getByType(DistributionContainer.class);
        Distribution distribution = (Distribution)distributions.create("boot");
        if (distribution instanceof IConventionAware) {
            ((IConventionAware)distribution).getConventionMapping().map("baseName", () -> applicationConvention.getApplicationName() + "-boot");
        }
        CreateBootStartScripts bootStartScripts = (CreateBootStartScripts)project.getTasks().create("bootStartScripts", CreateBootStartScripts.class);
        bootStartScripts.setDescription("Generates OS-specific start scripts to run the project as a Spring Boot application.");
        ((TemplateBasedScriptGenerator)bootStartScripts.getUnixStartScriptGenerator()).setTemplate(project.getResources().getText().fromString(this.loadResource("/unixStartScript.txt")));
        ((TemplateBasedScriptGenerator)bootStartScripts.getWindowsStartScriptGenerator()).setTemplate(project.getResources().getText().fromString(this.loadResource("/windowsStartScript.txt")));
        project.getConfigurations().all(configuration -> {
            if ("bootArchives".equals(configuration.getName())) {
                distribution.getContents().with(new CopySpec[]{project.copySpec().into((Object)"lib").from(new Object[]{() -> configuration.getArtifacts().getFiles()})});
                bootStartScripts.setClasspath(configuration.getArtifacts().getFiles());
            }
        });
        bootStartScripts.getConventionMapping().map("outputDir", () -> new File(project.getBuildDir(), "bootScripts"));
        bootStartScripts.getConventionMapping().map("applicationName", () -> ((ApplicationPluginConvention)applicationConvention).getApplicationName());
        CopySpec binCopySpec = project.copySpec().into((Object)"bin").from(new Object[]{bootStartScripts});
        binCopySpec.setFileMode(Integer.valueOf(1877));
        distribution.getContents().with(new CopySpec[]{binCopySpec});
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return ApplicationPlugin.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(String name) {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(name));){
            char[] buffer = new char[4096];
            int read = 0;
            StringWriter writer = new StringWriter();
            while ((read = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException ex) {
            throw new GradleException("Failed to read '" + name + "'", (Throwable)ex);
        }
    }
}

