/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.agent;

import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.JavaExec;
import org.springframework.boot.gradle.SpringBootPluginExtension;

public class AgentTasksEnhancer
implements Action<Project> {
    private static final String SPRING_LOADED_AGENT_CLASSNAME = "org.springsource.loaded.agent.SpringLoadedAgent";
    private File agent;
    private Boolean noverify;

    public void execute(Project project) {
        this.setup(project);
        if (this.agent != null) {
            for (Task task : project.getTasks()) {
                this.addAgent(project, task);
            }
        }
    }

    private void setup(Project project) {
        project.getLogger().info("Configuring agent");
        SpringBootPluginExtension extension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        this.noverify = extension.getNoverify();
        this.agent = this.getAgent(project, extension);
        if (this.agent == null) {
            this.agent = this.getSpringLoadedAgent();
            if (this.noverify == null) {
                this.noverify = true;
            }
        }
        project.getLogger().debug("Agent: " + this.agent);
    }

    private File getAgent(Project project, SpringBootPluginExtension extension) {
        if (project.hasProperty("run.agent")) {
            return project.file(project.property("run.agent"));
        }
        return extension.getAgent();
    }

    private File getSpringLoadedAgent() {
        try {
            CodeSource source;
            Class<?> loaded = Class.forName(SPRING_LOADED_AGENT_CLASSNAME);
            if (loaded != null && (source = loaded.getProtectionDomain().getCodeSource()) != null) {
                try {
                    return new File(source.getLocation().toURI());
                }
                catch (URISyntaxException ex) {
                    return new File(source.getLocation().getPath());
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void addAgent(Project project, Task task) {
        if (task instanceof JavaExec) {
            this.addAgent(project, (JavaExec)task);
        }
    }

    private void addAgent(Project project, JavaExec exec) {
        project.getLogger().debug("Attaching to: " + exec);
        if (this.agent != null) {
            Iterable defaultJvmArgs;
            project.getLogger().info("Attaching agent: " + this.agent);
            exec.jvmArgs(new Object[]{"-javaagent:" + this.agent.getAbsolutePath()});
            if (this.noverify != null && this.noverify.booleanValue()) {
                exec.jvmArgs(new Object[]{"-noverify"});
            }
            if ((defaultJvmArgs = (Iterable)exec.getConventionMapping().getConventionValue(null, "jvmArgs", false)) != null) {
                exec.jvmArgs(defaultJvmArgs);
            }
        }
    }
}

