/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.filewatch;

import java.io.File;
import java.io.FileFilter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.boot.devtools.filewatch.FileChangeListener;
import org.springframework.boot.devtools.filewatch.FolderSnapshot;
import org.springframework.util.Assert;

public class FileSystemWatcher {
    private static final Duration DEFAULT_POLL_INTERVAL = Duration.ofMillis(1000L);
    private static final Duration DEFAULT_QUIET_PERIOD = Duration.ofMillis(400L);
    private final List<FileChangeListener> listeners = new ArrayList<FileChangeListener>();
    private final boolean daemon;
    private final long pollInterval;
    private final long quietPeriod;
    private final AtomicInteger remainingScans = new AtomicInteger(-1);
    private final Map<File, FolderSnapshot> folders = new HashMap<File, FolderSnapshot>();
    private Thread watchThread;
    private FileFilter triggerFilter;
    private final Object monitor = new Object();

    public FileSystemWatcher() {
        this(true, DEFAULT_POLL_INTERVAL, DEFAULT_QUIET_PERIOD);
    }

    public FileSystemWatcher(boolean daemon, Duration pollInterval, Duration quietPeriod) {
        Assert.notNull((Object)pollInterval, (String)"PollInterval must not be null");
        Assert.notNull((Object)quietPeriod, (String)"QuietPeriod must not be null");
        Assert.isTrue((pollInterval.toMillis() > 0L ? 1 : 0) != 0, (String)"PollInterval must be positive");
        Assert.isTrue((quietPeriod.toMillis() > 0L ? 1 : 0) != 0, (String)"QuietPeriod must be positive");
        Assert.isTrue((pollInterval.toMillis() > quietPeriod.toMillis() ? 1 : 0) != 0, (String)"PollInterval must be greater than QuietPeriod");
        this.daemon = daemon;
        this.pollInterval = pollInterval.toMillis();
        this.quietPeriod = quietPeriod.toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileChangeListener fileChangeListener) {
        Assert.notNull((Object)fileChangeListener, (String)"FileChangeListener must not be null");
        Object object = this.monitor;
        synchronized (object) {
            this.checkNotStarted();
            this.listeners.add(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceFolders(Iterable<File> folders) {
        Assert.notNull(folders, (String)"Folders must not be null");
        Object object = this.monitor;
        synchronized (object) {
            for (File folder : folders) {
                this.addSourceFolder(folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceFolder(File folder) {
        Assert.notNull((Object)folder, (String)"Folder must not be null");
        Assert.isTrue((!folder.isFile() ? 1 : 0) != 0, (String)("Folder '" + folder + "' must not be a file"));
        Object object = this.monitor;
        synchronized (object) {
            this.checkNotStarted();
            this.folders.put(folder, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggerFilter(FileFilter triggerFilter) {
        Object object = this.monitor;
        synchronized (object) {
            this.triggerFilter = triggerFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStarted() {
        Object object = this.monitor;
        synchronized (object) {
            Assert.state((this.watchThread == null ? 1 : 0) != 0, (String)"FileSystemWatcher already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.monitor;
        synchronized (object) {
            this.saveInitialSnapshots();
            if (this.watchThread == null) {
                HashMap<File, FolderSnapshot> localFolders = new HashMap<File, FolderSnapshot>(this.folders);
                this.watchThread = new Thread(new Watcher(this.remainingScans, new ArrayList<FileChangeListener>(this.listeners), this.triggerFilter, this.pollInterval, this.quietPeriod, localFolders));
                this.watchThread.setName("File Watcher");
                this.watchThread.setDaemon(this.daemon);
                this.watchThread.start();
            }
        }
    }

    private void saveInitialSnapshots() {
        this.folders.replaceAll((f, v) -> new FolderSnapshot((File)f));
    }

    public void stop() {
        this.stopAfter(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAfter(int remainingScans) {
        Thread thread;
        Object object = this.monitor;
        synchronized (object) {
            thread = this.watchThread;
            if (thread != null) {
                this.remainingScans.set(remainingScans);
                if (remainingScans <= 0) {
                    thread.interrupt();
                }
            }
            this.watchThread = null;
        }
        if (thread != null && Thread.currentThread() != thread) {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class Watcher
    implements Runnable {
        private final AtomicInteger remainingScans;
        private final List<FileChangeListener> listeners;
        private final FileFilter triggerFilter;
        private final long pollInterval;
        private final long quietPeriod;
        private Map<File, FolderSnapshot> folders;

        private Watcher(AtomicInteger remainingScans, List<FileChangeListener> listeners, FileFilter triggerFilter, long pollInterval, long quietPeriod, Map<File, FolderSnapshot> folders) {
            this.remainingScans = remainingScans;
            this.listeners = listeners;
            this.triggerFilter = triggerFilter;
            this.pollInterval = pollInterval;
            this.quietPeriod = quietPeriod;
            this.folders = folders;
        }

        @Override
        public void run() {
            int remainingScans = this.remainingScans.get();
            while (remainingScans > 0 || remainingScans == -1) {
                try {
                    if (remainingScans > 0) {
                        this.remainingScans.decrementAndGet();
                    }
                    this.scan();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                remainingScans = this.remainingScans.get();
            }
        }

        private void scan() throws InterruptedException {
            Map<File, FolderSnapshot> previous;
            Thread.sleep(this.pollInterval - this.quietPeriod);
            Map<File, FolderSnapshot> current = this.folders;
            do {
                previous = current;
                current = this.getCurrentSnapshots();
                Thread.sleep(this.quietPeriod);
            } while (this.isDifferent(previous, current));
            if (this.isDifferent(this.folders, current)) {
                this.updateSnapshots(current.values());
            }
        }

        private boolean isDifferent(Map<File, FolderSnapshot> previous, Map<File, FolderSnapshot> current) {
            if (!previous.keySet().equals(current.keySet())) {
                return true;
            }
            for (Map.Entry<File, FolderSnapshot> entry : previous.entrySet()) {
                FolderSnapshot currentFolder;
                FolderSnapshot previousFolder = entry.getValue();
                if (previousFolder.equals(currentFolder = current.get(entry.getKey()), this.triggerFilter)) continue;
                return true;
            }
            return false;
        }

        private Map<File, FolderSnapshot> getCurrentSnapshots() {
            LinkedHashMap<File, FolderSnapshot> snapshots = new LinkedHashMap<File, FolderSnapshot>();
            for (File folder : this.folders.keySet()) {
                snapshots.put(folder, new FolderSnapshot(folder));
            }
            return snapshots;
        }

        private void updateSnapshots(Collection<FolderSnapshot> snapshots) {
            LinkedHashMap<File, FolderSnapshot> updated = new LinkedHashMap<File, FolderSnapshot>();
            LinkedHashSet<ChangedFiles> changeSet = new LinkedHashSet<ChangedFiles>();
            for (FolderSnapshot snapshot : snapshots) {
                FolderSnapshot previous = this.folders.get(snapshot.getFolder());
                updated.put(snapshot.getFolder(), snapshot);
                ChangedFiles changedFiles = previous.getChangedFiles(snapshot, this.triggerFilter);
                if (changedFiles.getFiles().isEmpty()) continue;
                changeSet.add(changedFiles);
            }
            if (!changeSet.isEmpty()) {
                this.fireListeners(Collections.unmodifiableSet(changeSet));
            }
            this.folders = updated;
        }

        private void fireListeners(Set<ChangedFiles> changeSet) {
            for (FileChangeListener listener : this.listeners) {
                listener.onChange(changeSet);
            }
        }
    }
}

