/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Conditional(value={DevToolsDataSourceCondition.class})
@Configuration
public class DevToolsDataSourceAutoConfiguration {
    @Bean
    NonEmbeddedInMemoryDatabaseShutdownExecutor inMemoryDatabaseShutdownExecutor(DataSource dataSource, DataSourceProperties dataSourceProperties) {
        return new NonEmbeddedInMemoryDatabaseShutdownExecutor(dataSource, dataSourceProperties);
    }

    static class DevToolsDataSourceCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        DevToolsDataSourceCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"DevTools DataSource Condition", (Object[])new Object[0]);
            String[] dataSourceBeanNames = context.getBeanFactory().getBeanNamesForType(DataSource.class);
            if (dataSourceBeanNames.length != 1) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("a single DataSource bean").atAll());
            }
            if (context.getBeanFactory().getBeanNamesForType(DataSourceProperties.class).length != 1) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("a single DataSourceProperties bean").atAll());
            }
            BeanDefinition dataSourceDefinition = context.getRegistry().getBeanDefinition(dataSourceBeanNames[0]);
            if (dataSourceDefinition instanceof AnnotatedBeanDefinition && ((AnnotatedBeanDefinition)dataSourceDefinition).getFactoryMethodMetadata() != null && ((AnnotatedBeanDefinition)dataSourceDefinition).getFactoryMethodMetadata().getDeclaringClassName().startsWith(DataSourceAutoConfiguration.class.getPackage().getName() + ".DataSourceConfiguration$")) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"auto-configured DataSource"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("an auto-configured DataSource").atAll());
        }
    }

    static final class NonEmbeddedInMemoryDatabaseShutdownExecutor
    implements DisposableBean {
        private final DataSource dataSource;
        private final DataSourceProperties dataSourceProperties;

        NonEmbeddedInMemoryDatabaseShutdownExecutor(DataSource dataSource, DataSourceProperties dataSourceProperties) {
            this.dataSource = dataSource;
            this.dataSourceProperties = dataSourceProperties;
        }

        public void destroy() throws Exception {
            for (InMemoryDatabase inMemoryDatabase : InMemoryDatabase.values()) {
                if (!inMemoryDatabase.matches(this.dataSourceProperties)) continue;
                inMemoryDatabase.shutdown(this.dataSource);
                return;
            }
        }

        private static enum InMemoryDatabase {
            DERBY(null, new HashSet<String>(Arrays.asList("org.apache.derby.jdbc.EmbeddedDriver")), dataSource -> {
                block2: {
                    String url = dataSource.getConnection().getMetaData().getURL();
                    try {
                        new EmbeddedDriver().connect(url + ";drop=true", new Properties());
                    }
                    catch (SQLException ex) {
                        if ("08006".equals(ex.getSQLState())) break block2;
                        throw ex;
                    }
                }
            }),
            H2("jdbc:h2:mem:", new HashSet<String>(Arrays.asList("org.h2.Driver", "org.h2.jdbcx.JdbcDataSource"))),
            HSQLDB("jdbc:hsqldb:mem:", new HashSet<String>(Arrays.asList("org.hsqldb.jdbcDriver", "org.hsqldb.jdbc.JDBCDriver", "org.hsqldb.jdbc.pool.JDBCXADataSource")));

            private final String urlPrefix;
            private final ShutdownHandler shutdownHandler;
            private final Set<String> driverClassNames;

            private InMemoryDatabase(String urlPrefix, Set<String> driverClassNames) {
                this(urlPrefix, driverClassNames, dataSource -> {
                    try (Connection connection = dataSource.getConnection();
                         Statement statement = connection.createStatement();){
                        statement.execute("SHUTDOWN");
                    }
                });
            }

            private InMemoryDatabase(String urlPrefix, Set<String> driverClassNames, ShutdownHandler shutdownHandler) {
                this.urlPrefix = urlPrefix;
                this.driverClassNames = driverClassNames;
                this.shutdownHandler = shutdownHandler;
            }

            boolean matches(DataSourceProperties properties) {
                String url = properties.getUrl();
                return (url == null || this.urlPrefix == null || url.startsWith(this.urlPrefix)) && this.driverClassNames.contains(properties.determineDriverClassName());
            }

            void shutdown(DataSource dataSource) throws SQLException {
                this.shutdownHandler.shutdown(dataSource);
            }

            @FunctionalInterface
            static interface ShutdownHandler {
                public void shutdown(DataSource var1) throws SQLException;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    static class DatabaseShutdownExecutorJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        DatabaseShutdownExecutorJpaDependencyConfiguration() {
            super(new String[]{"inMemoryDatabaseShutdownExecutor"});
        }
    }
}

