/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.boot.devtools.settings.DevToolsSettings;

final class ChangeableUrls
implements Iterable<URL> {
    private final List<URL> urls;

    private ChangeableUrls(URL ... urls) {
        DevToolsSettings settings = DevToolsSettings.get();
        ArrayList<URL> reloadableUrls = new ArrayList<URL>(urls.length);
        for (URL url : urls) {
            if (!settings.isRestartInclude(url) && !this.isFolderUrl(url.toString()) || settings.isRestartExclude(url)) continue;
            reloadableUrls.add(url);
        }
        this.urls = Collections.unmodifiableList(reloadableUrls);
    }

    private boolean isFolderUrl(String urlString) {
        return urlString.startsWith("file:") && urlString.endsWith("/");
    }

    @Override
    public Iterator<URL> iterator() {
        return this.urls.iterator();
    }

    public int size() {
        return this.urls.size();
    }

    public URL[] toArray() {
        return this.urls.toArray(new URL[this.urls.size()]);
    }

    public List<URL> toList() {
        return Collections.unmodifiableList(this.urls);
    }

    public String toString() {
        return this.urls.toString();
    }

    public static ChangeableUrls fromUrlClassLoader(URLClassLoader classLoader) {
        return ChangeableUrls.fromUrls(classLoader.getURLs());
    }

    public static ChangeableUrls fromUrls(Collection<URL> urls) {
        return ChangeableUrls.fromUrls(new ArrayList<URL>(urls).toArray(new URL[urls.size()]));
    }

    public static ChangeableUrls fromUrls(URL ... urls) {
        return new ChangeableUrls(urls);
    }
}

