/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.log4j2;

import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.springframework.boot.devtools.restart.RestartListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class Log4J2RestartListener
implements RestartListener {
    @Override
    public void beforeRestart() {
        if (ClassUtils.isPresent((String)"org.apache.logging.log4j.LogManager", (ClassLoader)this.getClass().getClassLoader())) {
            this.prepareLog4J2ForRestart();
        }
    }

    private void prepareLog4J2ForRestart() {
        LoggerContextFactory factory = LogManager.getFactory();
        Field field = ReflectionUtils.findField(factory.getClass(), (String)"shutdownCallbackRegistry");
        ReflectionUtils.makeAccessible((Field)field);
        ShutdownCallbackRegistry shutdownCallbackRegistry = (ShutdownCallbackRegistry)ReflectionUtils.getField((Field)field, (Object)factory);
        Field hooksField = ReflectionUtils.findField(shutdownCallbackRegistry.getClass(), (String)"hooks");
        ReflectionUtils.makeAccessible((Field)hooksField);
        Collection state = (Collection)ReflectionUtils.getField((Field)hooksField, (Object)shutdownCallbackRegistry);
        state.clear();
    }
}

