/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import io.lettuce.core.RedisClient;
import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerCommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerOptions;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.redis.autoconfigure.ClientResourcesBuilderCustomizer;
import org.springframework.boot.data.redis.autoconfigure.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={RedisAutoConfiguration.class}, afterName={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnClass(value={RedisClient.class, MicrometerCommandLatencyRecorder.class, MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
public final class LettuceMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MicrometerOptions micrometerOptions() {
        return MicrometerOptions.create();
    }

    @Bean
    ClientResourcesBuilderCustomizer lettuceMetrics(MeterRegistry meterRegistry, MicrometerOptions options) {
        return client -> client.commandLatencyRecorder((CommandLatencyRecorder)new MicrometerCommandLatencyRecorder(meterRegistry, options));
    }
}

