/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.neo4j.autoconfigure;

import java.util.Set;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.neo4j.autoconfigure.DataNeo4jProperties;
import org.springframework.boot.neo4j.autoconfigure.Neo4jAutoConfiguration;
import org.springframework.boot.persistence.autoconfigure.EntityScanner;
import org.springframework.boot.transaction.autoconfigure.TransactionAutoConfiguration;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizationAutoConfiguration;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizers;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.neo4j.aot.Neo4jManagedTypes;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;

@AutoConfiguration(before={TransactionAutoConfiguration.class}, after={Neo4jAutoConfiguration.class, TransactionManagerCustomizationAutoConfiguration.class})
@ConditionalOnClass(value={Driver.class, Neo4jTransactionManager.class, PlatformTransactionManager.class})
@EnableConfigurationProperties(value={DataNeo4jProperties.class})
@ConditionalOnBean(value={Driver.class})
public final class Neo4jDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Neo4jConversions neo4jConversions() {
        return new Neo4jConversions();
    }

    @Bean
    @ConditionalOnMissingBean
    Neo4jManagedTypes neo4jManagedTypes(ApplicationContext applicationContext) throws ClassNotFoundException {
        Set initialEntityClasses = new EntityScanner(applicationContext).scan(new Class[]{Node.class, RelationshipProperties.class});
        return Neo4jManagedTypes.fromIterable((Iterable)initialEntityClasses);
    }

    @Bean
    @ConditionalOnMissingBean
    Neo4jMappingContext neo4jMappingContext(Neo4jManagedTypes managedTypes, Neo4jConversions neo4jConversions) {
        Neo4jMappingContext context = new Neo4jMappingContext(neo4jConversions);
        context.setManagedTypes((ManagedTypes)managedTypes);
        return context;
    }

    @Bean
    @ConditionalOnMissingBean
    DatabaseSelectionProvider databaseSelectionProvider(DataNeo4jProperties properties) {
        String database = properties.getDatabase();
        return database != null ? DatabaseSelectionProvider.createStaticDatabaseSelectionProvider((String)database) : DatabaseSelectionProvider.getDefaultSelectionProvider();
    }

    @Bean(value={"neo4jClient"})
    @ConditionalOnMissingBean
    Neo4jClient neo4jClient(Driver driver, DatabaseSelectionProvider databaseNameProvider) {
        return Neo4jClient.create((Driver)driver, (DatabaseSelectionProvider)databaseNameProvider);
    }

    @Bean(value={"neo4jTemplate"})
    @ConditionalOnMissingBean(value={Neo4jOperations.class})
    Neo4jTemplate neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext) {
        return new Neo4jTemplate(neo4jClient, neo4jMappingContext);
    }

    @Bean(value={"transactionManager"})
    @ConditionalOnMissingBean(value={TransactionManager.class})
    Neo4jTransactionManager transactionManager(Driver driver, DatabaseSelectionProvider databaseNameProvider, ObjectProvider<TransactionManagerCustomizers> optionalCustomizers) {
        Neo4jTransactionManager transactionManager = new Neo4jTransactionManager(driver, databaseNameProvider);
        optionalCustomizers.ifAvailable(customizer -> customizer.customize((TransactionManager)transactionManager));
        return transactionManager;
    }
}

