/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.neo4j.autoconfigure;

import org.neo4j.driver.Driver;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.neo4j.autoconfigure.Neo4jDataAutoConfiguration;
import org.springframework.boot.data.neo4j.autoconfigure.Neo4jDataProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.ReactiveNeo4jTemplate;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.transaction.ReactiveTransactionManager;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={Neo4jDataAutoConfiguration.class})
@ConditionalOnClass(value={Driver.class, ReactiveNeo4jTemplate.class, ReactiveTransactionManager.class, Flux.class})
@ConditionalOnBean(value={Driver.class})
@EnableConfigurationProperties(value={Neo4jDataProperties.class})
public class Neo4jReactiveDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ReactiveDatabaseSelectionProvider reactiveDatabaseSelectionProvider(Neo4jDataProperties dataProperties) {
        String database = dataProperties.getDatabase();
        return database != null ? ReactiveDatabaseSelectionProvider.createStaticDatabaseSelectionProvider((String)database) : ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider();
    }

    @Bean(value={"reactiveNeo4jClient"})
    @ConditionalOnMissingBean
    public ReactiveNeo4jClient reactiveNeo4jClient(Driver driver, ReactiveDatabaseSelectionProvider databaseNameProvider) {
        return ReactiveNeo4jClient.create((Driver)driver, (ReactiveDatabaseSelectionProvider)databaseNameProvider);
    }

    @Bean(value={"reactiveNeo4jTemplate"})
    @ConditionalOnMissingBean(value={ReactiveNeo4jOperations.class})
    @ConditionalOnBean(value={Neo4jMappingContext.class})
    public ReactiveNeo4jTemplate reactiveNeo4jTemplate(ReactiveNeo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext) {
        return new ReactiveNeo4jTemplate(neo4jClient, neo4jMappingContext);
    }
}

