/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.elasticsearch.autoconfigure.health;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.elasticsearch.health.ElasticsearchReactiveHealthIndicator;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchReactiveClientAutoConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={ElasticsearchReactiveClientAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveElasticsearchClient.class, Flux.class, ElasticsearchReactiveHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={ReactiveElasticsearchClient.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
public final class ElasticsearchReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<ElasticsearchReactiveHealthIndicator, ReactiveElasticsearchClient> {
    ElasticsearchReactiveHealthContributorAutoConfiguration() {
        super(ElasticsearchReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator", "elasticsearchHealthContributor"})
    ReactiveHealthContributor elasticsearchHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, ReactiveElasticsearchClient.class);
    }
}

