/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloudfoundry.actuate.autoconfigure.endpoint.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.cloudfoundry.actuate.autoconfigure.endpoint.AccessLevel;
import org.springframework.boot.cloudfoundry.actuate.autoconfigure.endpoint.SecurityResponse;
import org.springframework.boot.cloudfoundry.actuate.autoconfigure.endpoint.servlet.SecurityInterceptor;
import org.springframework.boot.webmvc.actuate.endpoint.web.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;

@ImportRuntimeHints(value={CloudFoundryWebEndpointServletHandlerMappingRuntimeHints.class})
class CloudFoundryWebEndpointServletHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private static final Log logger = LogFactory.getLog(CloudFoundryWebEndpointServletHandlerMapping.class);
    private final SecurityInterceptor securityInterceptor;
    private final EndpointLinksResolver linksResolver;
    private final Collection<ExposableEndpoint<?>> allEndpoints;

    CloudFoundryWebEndpointServletHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, SecurityInterceptor securityInterceptor, Collection<ExposableEndpoint<?>> allEndpoints) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration, true);
        this.securityInterceptor = securityInterceptor;
        this.linksResolver = new EndpointLinksResolver(allEndpoints);
        this.allEndpoints = allEndpoints;
    }

    protected AbstractWebMvcEndpointHandlerMapping.ServletWebOperation wrapServletWebOperation(ExposableWebEndpoint endpoint, WebOperation operation, AbstractWebMvcEndpointHandlerMapping.ServletWebOperation servletWebOperation) {
        return new SecureServletWebOperation(servletWebOperation, this.securityInterceptor, endpoint.getEndpointId());
    }

    protected AbstractWebMvcEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return new CloudFoundryLinksHandler();
    }

    Collection<ExposableEndpoint<?>> getAllEndpoints() {
        return this.allEndpoints;
    }

    private static class SecureServletWebOperation
    implements AbstractWebMvcEndpointHandlerMapping.ServletWebOperation {
        private final AbstractWebMvcEndpointHandlerMapping.ServletWebOperation delegate;
        private final SecurityInterceptor securityInterceptor;
        private final EndpointId endpointId;

        SecureServletWebOperation(AbstractWebMvcEndpointHandlerMapping.ServletWebOperation delegate, SecurityInterceptor securityInterceptor, EndpointId endpointId) {
            this.delegate = delegate;
            this.securityInterceptor = securityInterceptor;
            this.endpointId = endpointId;
        }

        public @Nullable Object handle(HttpServletRequest request, @Nullable Map<String, String> body) {
            SecurityResponse securityResponse = this.securityInterceptor.preHandle(request, this.endpointId);
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return new ResponseEntity((Object)securityResponse.getMessage(), (HttpStatusCode)securityResponse.getStatus());
            }
            return this.delegate.handle(request, body);
        }
    }

    class CloudFoundryLinksHandler
    implements AbstractWebMvcEndpointHandlerMapping.LinksHandler {
        CloudFoundryLinksHandler() {
        }

        @ResponseBody
        @Reflective
        public Map<String, Map<String, Link>> links(HttpServletRequest request, HttpServletResponse response) {
            SecurityResponse securityResponse = CloudFoundryWebEndpointServletHandlerMapping.this.securityInterceptor.preHandle(request, null);
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                this.sendFailureResponse(response, securityResponse);
            }
            AccessLevel accessLevel = (AccessLevel)((Object)request.getAttribute("cloudFoundryAccessLevel"));
            Map<Object, Object> filteredLinks = new LinkedHashMap();
            if (accessLevel == null) {
                return Collections.singletonMap("_links", filteredLinks);
            }
            Map links = CloudFoundryWebEndpointServletHandlerMapping.this.linksResolver.resolveLinks(request.getRequestURL().toString());
            filteredLinks = links.entrySet().stream().filter(e -> ((String)e.getKey()).equals("self") || accessLevel.isAccessAllowed((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return Collections.singletonMap("_links", filteredLinks);
        }

        public String toString() {
            return "Actuator root web endpoint";
        }

        private void sendFailureResponse(HttpServletResponse response, SecurityResponse securityResponse) {
            try {
                response.sendError(securityResponse.getStatus().value(), securityResponse.getMessage());
            }
            catch (Exception ex) {
                logger.debug((Object)"Failed to send error response", (Throwable)ex);
            }
        }
    }

    static class CloudFoundryWebEndpointServletHandlerMappingRuntimeHints
    implements RuntimeHintsRegistrar {
        private final ReflectiveRuntimeHintsRegistrar reflectiveRegistrar = new ReflectiveRuntimeHintsRegistrar();
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        CloudFoundryWebEndpointServletHandlerMappingRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            this.reflectiveRegistrar.registerRuntimeHints(hints, new Class[]{CloudFoundryLinksHandler.class});
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Link.class});
        }
    }
}

