/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cassandra.docker.compose;

import java.util.List;
import org.springframework.boot.cassandra.autoconfigure.CassandraConnectionDetails;
import org.springframework.boot.cassandra.docker.compose.CassandraEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class CassandraDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<CassandraConnectionDetails> {
    private static final String[] CASSANDRA_CONTAINER_NAMES = new String[]{"cassandra", "bitnami/cassandra"};
    private static final int CASSANDRA_PORT = 9042;

    CassandraDockerComposeConnectionDetailsFactory() {
        super(CASSANDRA_CONTAINER_NAMES, new String[0]);
    }

    protected CassandraConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new CassandraDockerComposeConnectionDetails(source.getRunningService());
    }

    static class CassandraDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements CassandraConnectionDetails {
        private final List<CassandraConnectionDetails.Node> contactPoints;
        private final String datacenter;

        CassandraDockerComposeConnectionDetails(RunningService service) {
            super(service);
            CassandraEnvironment cassandraEnvironment = new CassandraEnvironment(service.env());
            this.contactPoints = List.of(new CassandraConnectionDetails.Node(service.host(), service.ports().get(9042)));
            this.datacenter = cassandraEnvironment.getDatacenter();
        }

        @Override
        public List<CassandraConnectionDetails.Node> getContactPoints() {
            return this.contactPoints;
        }

        @Override
        public String getLocalDatacenter() {
            return this.datacenter;
        }
    }
}

