/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cassandra.autoconfigure;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.ssl.ProgrammaticSslEngineFactory;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cassandra.autoconfigure.CassandraConnectionDetails;
import org.springframework.boot.cassandra.autoconfigure.CassandraProperties;
import org.springframework.boot.cassandra.autoconfigure.CqlSessionBuilderCustomizer;
import org.springframework.boot.cassandra.autoconfigure.DriverConfigLoaderBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={CqlSession.class})
@EnableConfigurationProperties(value={CassandraProperties.class})
public class CassandraAutoConfiguration {
    private static final Config SPRING_BOOT_DEFAULTS;
    private final CassandraProperties properties;

    CassandraAutoConfiguration(CassandraProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={CassandraConnectionDetails.class})
    PropertiesCassandraConnectionDetails cassandraConnectionDetails(ObjectProvider<SslBundles> sslBundles) {
        return new PropertiesCassandraConnectionDetails(this.properties, (SslBundles)sslBundles.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy
    public CqlSession cassandraSession(CqlSessionBuilder cqlSessionBuilder) {
        return (CqlSession)cqlSessionBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public CqlSessionBuilder cassandraSessionBuilder(DriverConfigLoader driverConfigLoader, CassandraConnectionDetails connectionDetails, ObjectProvider<CqlSessionBuilderCustomizer> builderCustomizers) {
        CqlSessionBuilder builder = (CqlSessionBuilder)CqlSession.builder().withConfigLoader(driverConfigLoader);
        this.configureAuthentication(builder, connectionDetails);
        this.configureSsl(builder, connectionDetails);
        builder.withKeyspace(this.properties.getKeyspaceName());
        builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private void configureAuthentication(CqlSessionBuilder builder, CassandraConnectionDetails connectionDetails) {
        String username = connectionDetails.getUsername();
        if (username != null) {
            builder.withAuthCredentials(username, connectionDetails.getPassword());
        }
    }

    private void configureSsl(CqlSessionBuilder builder, CassandraConnectionDetails connectionDetails) {
        SslBundle sslBundle = connectionDetails.getSslBundle();
        if (sslBundle == null) {
            return;
        }
        SslOptions options = sslBundle.getOptions();
        Assert.state((options.getEnabledProtocols() == null ? 1 : 0) != 0, (String)"SSL protocol options cannot be specified with Cassandra");
        builder.withSslEngineFactory((SslEngineFactory)new ProgrammaticSslEngineFactory(sslBundle.createSslContext(), options.getCiphers()));
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public DriverConfigLoader cassandraDriverConfigLoader(CassandraConnectionDetails connectionDetails, ObjectProvider<DriverConfigLoaderBuilderCustomizer> builderCustomizers) {
        DefaultProgrammaticDriverConfigLoaderBuilder builder = new DefaultProgrammaticDriverConfigLoaderBuilder(() -> this.cassandraConfiguration(connectionDetails), "datastax-java-driver");
        builderCustomizers.orderedStream().forEach(arg_0 -> CassandraAutoConfiguration.lambda$cassandraDriverConfigLoader$1((ProgrammaticDriverConfigLoaderBuilder)builder, arg_0));
        return builder.build();
    }

    private Config cassandraConfiguration(CassandraConnectionDetails connectionDetails) {
        ConfigFactory.invalidateCaches();
        Config config = ConfigFactory.defaultOverrides();
        config = config.withFallback((ConfigMergeable)this.mapConfig(connectionDetails));
        if (this.properties.getConfig() != null) {
            config = config.withFallback((ConfigMergeable)this.loadConfig(this.properties.getConfig()));
        }
        config = config.withFallback((ConfigMergeable)SPRING_BOOT_DEFAULTS);
        config = config.withFallback((ConfigMergeable)ConfigFactory.defaultReferenceUnresolved());
        return config.resolve();
    }

    private Config loadConfig(Resource resource) {
        try {
            return ConfigFactory.parseURL((URL)resource.getURL());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load cassandra configuration from " + String.valueOf(resource), ex);
        }
    }

    private Config mapConfig(CassandraConnectionDetails connectionDetails) {
        CassandraDriverOptions options = new CassandraDriverOptions();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from((Object)this.properties.getSessionName()).whenHasText().to(sessionName -> options.add((DriverOption)DefaultDriverOption.SESSION_NAME, (String)sessionName));
        map.from((Object)connectionDetails.getUsername()).to(value -> options.add((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, (String)value).add((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, connectionDetails.getPassword()));
        map.from(this.properties::getCompression).to(compression -> options.add((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, (Enum<?>)compression));
        this.mapConnectionOptions(options);
        this.mapPoolingOptions(options);
        this.mapRequestOptions(options);
        this.mapControlConnectionOptions(options);
        map.from(this.mapContactPoints(connectionDetails)).to(contactPoints -> options.add((DriverOption)DefaultDriverOption.CONTACT_POINTS, (List<String>)contactPoints));
        map.from((Object)connectionDetails.getLocalDatacenter()).whenHasText().to(localDatacenter -> options.add((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, (String)localDatacenter));
        return options.build();
    }

    private void mapConnectionOptions(CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Connection connectionProperties = this.properties.getConnection();
        map.from(connectionProperties::getConnectTimeout).asInt(Duration::toMillis).to(connectTimeout -> options.add((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, (int)connectTimeout));
        map.from(connectionProperties::getInitQueryTimeout).asInt(Duration::toMillis).to(initQueryTimeout -> options.add((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, (int)initQueryTimeout));
    }

    private void mapPoolingOptions(CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Pool poolProperties = this.properties.getPool();
        map.from(poolProperties::getIdleTimeout).asInt(Duration::toMillis).to(idleTimeout -> options.add((DriverOption)DefaultDriverOption.HEARTBEAT_TIMEOUT, (int)idleTimeout));
        map.from(poolProperties::getHeartbeatInterval).asInt(Duration::toMillis).to(heartBeatInterval -> options.add((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, (int)heartBeatInterval));
    }

    private void mapRequestOptions(CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Request requestProperties = this.properties.getRequest();
        map.from(requestProperties::getTimeout).asInt(Duration::toMillis).to(timeout -> options.add((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, (int)timeout));
        map.from(requestProperties::getConsistency).to(consistency -> options.add((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, (Enum<?>)consistency));
        map.from(requestProperties::getSerialConsistency).to(serialConsistency -> options.add((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, (Enum<?>)serialConsistency));
        map.from(requestProperties::getPageSize).to(pageSize -> options.add((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, (int)pageSize));
        CassandraProperties.Throttler throttlerProperties = requestProperties.getThrottler();
        map.from(throttlerProperties::getType).as(CassandraProperties.ThrottlerType::type).to(type -> options.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_CLASS, (String)type));
        map.from(throttlerProperties::getMaxQueueSize).to(maxQueueSize -> options.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE, (int)maxQueueSize));
        map.from(throttlerProperties::getMaxConcurrentRequests).to(maxConcurrentRequests -> options.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS, (int)maxConcurrentRequests));
        map.from(throttlerProperties::getMaxRequestsPerSecond).to(maxRequestsPerSecond -> options.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_MAX_REQUESTS_PER_SECOND, (int)maxRequestsPerSecond));
        map.from(throttlerProperties::getDrainInterval).asInt(Duration::toMillis).to(drainInterval -> options.add((DriverOption)DefaultDriverOption.REQUEST_THROTTLER_DRAIN_INTERVAL, (int)drainInterval));
    }

    private void mapControlConnectionOptions(CassandraDriverOptions options) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        CassandraProperties.Controlconnection controlProperties = this.properties.getControlconnection();
        map.from(controlProperties::getTimeout).asInt(Duration::toMillis).to(timeout -> options.add((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, (int)timeout));
    }

    private List<String> mapContactPoints(CassandraConnectionDetails connectionDetails) {
        return connectionDetails.getContactPoints().stream().map(node -> node.host() + ":" + node.port()).toList();
    }

    private static /* synthetic */ void lambda$cassandraDriverConfigLoader$1(ProgrammaticDriverConfigLoaderBuilder builder, DriverConfigLoaderBuilderCustomizer customizer) {
        customizer.customize(builder);
    }

    static {
        CassandraDriverOptions options = new CassandraDriverOptions();
        options.add((DriverOption)DefaultDriverOption.CONTACT_POINTS, Collections.singletonList("127.0.0.1:9042"));
        options.add((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none");
        options.add((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, (int)Duration.ofSeconds(5L).toMillis());
        SPRING_BOOT_DEFAULTS = options.build();
    }

    static final class PropertiesCassandraConnectionDetails
    implements CassandraConnectionDetails {
        private final CassandraProperties properties;
        private final SslBundles sslBundles;

        private PropertiesCassandraConnectionDetails(CassandraProperties properties, SslBundles sslBundles) {
            this.properties = properties;
            this.sslBundles = sslBundles;
        }

        @Override
        public List<CassandraConnectionDetails.Node> getContactPoints() {
            List<String> contactPoints = this.properties.getContactPoints();
            return contactPoints != null ? contactPoints.stream().map(this::asNode).toList() : Collections.emptyList();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public String getLocalDatacenter() {
            return this.properties.getLocalDatacenter();
        }

        @Override
        public SslBundle getSslBundle() {
            CassandraProperties.Ssl ssl = this.properties.getSsl();
            if (ssl == null || !ssl.isEnabled()) {
                return null;
            }
            if (StringUtils.hasLength((String)ssl.getBundle())) {
                Assert.notNull((Object)this.sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
                return this.sslBundles.getBundle(ssl.getBundle());
            }
            return SslBundle.systemDefault();
        }

        private CassandraConnectionDetails.Node asNode(String contactPoint) {
            String portCandidate;
            Integer port;
            int i = contactPoint.lastIndexOf(58);
            if (i >= 0 && (port = this.asPort(portCandidate = contactPoint.substring(i + 1))) != null) {
                return new CassandraConnectionDetails.Node(contactPoint.substring(0, i), port);
            }
            return new CassandraConnectionDetails.Node(contactPoint, this.properties.getPort());
        }

        private Integer asPort(String value) {
            try {
                int i = Integer.parseInt(value);
                return i > 0 && i < 65535 ? Integer.valueOf(i) : null;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private static final class CassandraDriverOptions {
        private final Map<String, String> options = new LinkedHashMap<String, String>();

        private CassandraDriverOptions() {
        }

        private CassandraDriverOptions add(DriverOption option, String value) {
            String key = CassandraDriverOptions.createKeyFor(option);
            this.options.put(key, value);
            return this;
        }

        private CassandraDriverOptions add(DriverOption option, int value) {
            return this.add(option, String.valueOf(value));
        }

        private CassandraDriverOptions add(DriverOption option, Enum<?> value) {
            return this.add(option, value.name());
        }

        private CassandraDriverOptions add(DriverOption option, List<String> values) {
            for (int i = 0; i < values.size(); ++i) {
                this.options.put(String.format("%s.%s", CassandraDriverOptions.createKeyFor(option), i), values.get(i));
            }
            return this;
        }

        private Config build() {
            return ConfigFactory.parseMap(this.options, (String)"Environment");
        }

        private static String createKeyFor(DriverOption option) {
            return String.format("%s.%s", "datastax-java-driver", option.getPath());
        }
    }
}

