/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.util.Assert;

public final class SimpleRabbitListenerContainerFactoryConfigurer {
    private RabbitProperties rabbitProperties;

    void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    public void configure(SimpleRabbitListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        Assert.notNull((Object)factory, (String)"Factory must not be null");
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        factory.setConnectionFactory(connectionFactory);
        RabbitProperties.Listener listenerConfig = this.rabbitProperties.getListener();
        factory.setAutoStartup(Boolean.valueOf(listenerConfig.isAutoStartup()));
        if (listenerConfig.getAcknowledgeMode() != null) {
            factory.setAcknowledgeMode(listenerConfig.getAcknowledgeMode());
        }
        if (listenerConfig.getConcurrency() != null) {
            factory.setConcurrentConsumers(listenerConfig.getConcurrency());
        }
        if (listenerConfig.getMaxConcurrency() != null) {
            factory.setMaxConcurrentConsumers(listenerConfig.getMaxConcurrency());
        }
        if (listenerConfig.getPrefetch() != null) {
            factory.setPrefetchCount(listenerConfig.getPrefetch());
        }
        if (listenerConfig.getTransactionSize() != null) {
            factory.setTxSize(listenerConfig.getTransactionSize());
        }
    }
}

